package com.softgarden.baselibrary.base

import android.widget.CompoundButton
import com.chad.library.adapter.base.BaseQuickAdapter

/**
 * @author by DELL
 * @date on 2020/06/11
 * @describe RecyclerView Adapter的基类
 */
abstract class BaseRVAdapter<T>(layoutResId: Int) : BaseQuickAdapter<T, BaseRVHolder>(layoutResId) {

    override fun convert(helper: BaseRVHolder, item: T) {
        onBindVH(helper, item, helper.layoutPosition - headerLayoutCount)
    }

   abstract fun onBindVH(holder: BaseRVHolder, data: T, position: Int)

    protected fun setCheckedChange(cb: CompoundButton, position: Int) {
        cb.setOnCheckedChangeListener { buttonView, isChecked -> if (onViewCheckedChangeListener != null) onViewCheckedChangeListener!!.onViewCheckedChanged(buttonView, isChecked, position) }
    }

    /**
     * @param onViewClickListener
     */
    var onViewCheckedChangeListener: OnViewCheckedChangeListener? = null

    interface OnViewCheckedChangeListener {
        fun onViewCheckedChanged(buttonView: CompoundButton?, isChecked: Boolean, position: Int)
    }
}