package com.softgarden.baselibrary.base

import android.graphics.Bitmap
import android.graphics.Typeface
import android.graphics.drawable.Drawable
import android.view.View
import android.view.View.OnLongClickListener
import android.view.View.OnTouchListener
import android.widget.Adapter
import android.widget.AdapterView
import android.widget.AdapterView.OnItemSelectedListener
import android.widget.CompoundButton
import androidx.annotation.IdRes
import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.BaseViewHolder

/**
 * @author by DELL
 * @date on 2020/06/11
 * @describe ViewHolder基类 封装
 */
class BaseRVHolder(view: View?) : BaseViewHolder(view) {
//    fun <T : View?> get(id: Int): T {
//        return getView(id)
//    }

    /**
     * 从新定义
     * @param viewId
     * @param visible
     * @return
     */
    override fun setVisible(@IdRes viewId: Int, visible: Boolean): BaseRVHolder {
        val view = getView<View>(viewId)
        view.visibility = if (visible) View.VISIBLE else View.GONE
        return this
    }

    fun setSelected(@IdRes viewId: Int, selected: Boolean): BaseRVHolder {
        val view = getView<View>(viewId)
        view.isSelected = selected
        return this
    }

    override fun setText(viewId: Int, value: CharSequence): BaseRVHolder {
        return super.setText(viewId, value) as BaseRVHolder
    }

    override fun setText(viewId: Int, strId: Int): BaseRVHolder {
        return super.setText(viewId, strId) as BaseRVHolder
    }

    override fun setImageResource(viewId: Int, imageResId: Int): BaseRVHolder {
        return super.setImageResource(viewId, imageResId) as BaseRVHolder
    }

    override fun setBackgroundColor(viewId: Int, color: Int): BaseRVHolder {
        return super.setBackgroundColor(viewId, color) as BaseRVHolder
    }

    override fun setBackgroundRes(viewId: Int, backgroundRes: Int): BaseRVHolder {
        return super.setBackgroundRes(viewId, backgroundRes) as BaseRVHolder
    }

    override fun setTextColor(viewId: Int, textColor: Int): BaseRVHolder {
        return super.setTextColor(viewId, textColor) as BaseRVHolder
    }

    override fun setImageDrawable(viewId: Int, drawable: Drawable): BaseRVHolder {
        return super.setImageDrawable(viewId, drawable) as BaseRVHolder
    }

    override fun setImageBitmap(viewId: Int, bitmap: Bitmap): BaseRVHolder {
        return super.setImageBitmap(viewId, bitmap) as BaseRVHolder
    }

    override fun setAlpha(viewId: Int, value: Float): BaseRVHolder {
        return super.setAlpha(viewId, value) as BaseRVHolder
    }

    override fun setGone(viewId: Int, visible: Boolean): BaseRVHolder {
        return super.setGone(viewId, visible) as BaseRVHolder
    }

    override fun linkify(viewId: Int): BaseRVHolder {
        return super.linkify(viewId) as BaseRVHolder
    }

    override fun setTypeface(viewId: Int, typeface: Typeface): BaseRVHolder {
        return super.setTypeface(viewId, typeface) as BaseRVHolder
    }

    override fun setTypeface(typeface: Typeface, vararg viewIds: Int): BaseRVHolder {
        return super.setTypeface(typeface, *viewIds) as BaseRVHolder
    }

    override fun setProgress(viewId: Int, progress: Int): BaseRVHolder {
        return super.setProgress(viewId, progress) as BaseRVHolder
    }

    override fun setProgress(viewId: Int, progress: Int, max: Int): BaseRVHolder {
        return super.setProgress(viewId, progress, max) as BaseRVHolder
    }

    override fun setMax(viewId: Int, max: Int): BaseRVHolder {
        return super.setMax(viewId, max) as BaseRVHolder
    }

    override fun setRating(viewId: Int, rating: Float): BaseRVHolder {
        return super.setRating(viewId, rating) as BaseRVHolder
    }

    override fun setRating(viewId: Int, rating: Float, max: Int): BaseRVHolder {
        return super.setRating(viewId, rating, max) as BaseRVHolder
    }

    override fun setOnClickListener(viewId: Int, listener: View.OnClickListener): BaseRVHolder {
        return super.setOnClickListener(viewId, listener) as BaseRVHolder
    }

    override fun addOnClickListener(viewId: Int): BaseRVHolder {
        return super.addOnClickListener(viewId) as BaseRVHolder
    }

    override fun setNestView(viewId: Int): BaseRVHolder {
        return super.setNestView(viewId) as BaseRVHolder
    }

    override fun addOnLongClickListener(viewId: Int): BaseRVHolder {
        return super.addOnLongClickListener(viewId) as BaseRVHolder
    }

    override fun setOnTouchListener(viewId: Int, listener: OnTouchListener): BaseRVHolder {
        return super.setOnTouchListener(viewId, listener) as BaseRVHolder
    }

    override fun setOnLongClickListener(viewId: Int, listener: OnLongClickListener): BaseRVHolder {
        return super.setOnLongClickListener(viewId, listener) as BaseRVHolder
    }

    override fun setOnItemClickListener(viewId: Int, listener: AdapterView.OnItemClickListener): BaseRVHolder {
        return super.setOnItemClickListener(viewId, listener) as BaseRVHolder
    }

    override fun setOnItemLongClickListener(viewId: Int, listener: AdapterView.OnItemLongClickListener): BaseRVHolder {
        return super.setOnItemLongClickListener(viewId, listener) as BaseRVHolder
    }

    override fun setOnItemSelectedClickListener(viewId: Int, listener: OnItemSelectedListener): BaseRVHolder {
        return super.setOnItemSelectedClickListener(viewId, listener) as BaseRVHolder
    }

    override fun setOnCheckedChangeListener(viewId: Int, listener: CompoundButton.OnCheckedChangeListener): BaseRVHolder {
        return super.setOnCheckedChangeListener(viewId, listener) as BaseRVHolder
    }

    override fun setTag(viewId: Int, tag: Any): BaseRVHolder {
        return super.setTag(viewId, tag) as BaseRVHolder
    }

    override fun setTag(viewId: Int, key: Int, tag: Any): BaseRVHolder {
        return super.setTag(viewId, key, tag) as BaseRVHolder
    }

    override fun setChecked(viewId: Int, checked: Boolean): BaseRVHolder {
        return super.setChecked(viewId, checked) as BaseRVHolder
    }

    override fun setAdapter(viewId: Int, adapter: Adapter): BaseRVHolder {
        return super.setAdapter(viewId, adapter) as BaseRVHolder
    }

    override fun setAdapter(adapter: BaseQuickAdapter<*, *>?): BaseRVHolder {
        return super.setAdapter(adapter) as BaseRVHolder
    }
}