package com.softgarden.baselibrary.base

import android.util.Log
import android.view.View
import com.softgarden.baselibrary.R

import me.bakumon.statuslayoutmanager.library.OnStatusChildClickListener
import me.bakumon.statuslayoutmanager.library.StatusLayoutManager

/**
 * @author by DELL
 * @date on 2020/06/11
 * @describe Fragment基类 支持 预加载
 */
abstract class BaseVP2LazyFragment<P : IBasePresenter?> : BaseLazyFragment<P>() {


    override fun onResume() {
        super.onResume()
        if (isFirstVisible) {
            isFirstVisible = false
            initPrepare()
        } else {
            onUserVisible()
        }
    }

    override fun onPause() {
        super.onPause()
        if (isCanLazyLoad) {
            if (userVisibleHint) {
                onUserInvisible()
            }
        }
    }

    override fun setUserVisibleHint(isVisibleToUser: Boolean) {
        super.setUserVisibleHint(isVisibleToUser)
        if (isCanLazyLoad) {
            if (isVisibleToUser) {
                if (isFirstVisible) {
                    isFirstVisible = false
                    initPrepare()
                } else {
                    onUserVisible()
                }
            } else {
                if (isFirstInvisible) {
                    isFirstInvisible = false
                    onFirstUserInvisible()
                } else {
                    onUserInvisible()
                }
            }
        }
    }


    override fun initialize() {
        Log.e("fragment_initialize", this.javaClass.simpleName)
        initEventAndData()
        initPrepare()
    }





    override fun onDestroyView() {
        super.onDestroyView()
        isPrepared = false
        isFirstVisible = true
        isFirstResume = true
        isFirstVisible = true
        isFirstInvisible = true
    }

    companion object {
        private val TAG = BaseVP2LazyFragment::class.java.simpleName
    }
}