package com.softgarden.baselibrary.base


import android.text.TextUtils
import android.view.View
import android.view.ViewGroup
import androidx.fragment.app.Fragment
import androidx.fragment.app.FragmentManager
import androidx.fragment.app.FragmentStatePagerAdapter

/**
 * FragmentStatePagerAdapter 基类 配合ViewPager使用 简单快捷
 */
class FragmentBasePagerAdapter : FragmentStatePagerAdapter {
    private var fragments: List<Fragment>? = null
    private var fragmentsArray: Array<BaseFragment<*>>? = null
    private var titles: Array<String>? =null

    constructor(fm: FragmentManager?, fragment: ArrayList<Fragment>) : super(fm!!) {
        fragment?.apply {
            fragments = this
        }
    }

    constructor(fm: FragmentManager?,  fragment: List<Fragment>?, titles: Array<String>?) : super(fm!!) {
        fragment?.apply {
            fragments = this
        }
        if (titles == null || titles.size == 0) return
        this.titles = titles
    }

    constructor(fm: FragmentManager?, cls: Class<Fragment>, titles: Array<String>?) : super(fm!!) {
        if (titles == null || titles.size == 0) return
        this.titles = titles
//        fragmentsArray = Array<BaseFragment<*>>(titles.size)
//
//        for (i in titles.indices) {
//            try {
//                fragments?.set(i, cls.newInstance())
//            } catch (e: Exception) {
//                e.printStackTrace()
//            }
//        }
    }

    override fun getItem(position: Int): Fragment {
        val fragment = fragments!![position]
//        fragment as BaseFragment<*>
//        fragment.position = position
//        val pageTitle = getPageTitle(position)
//        if (!TextUtils.isEmpty(pageTitle)) fragment.title = pageTitle.toString()
        return fragment
    }

    override fun setPrimaryItem(container: ViewGroup, position: Int, `object`: Any) {
        super.setPrimaryItem(container, position, `object`)
    }

    override fun setPrimaryItem(container: View, position: Int, `object`: Any) {
        super.setPrimaryItem(container, position, `object`)
    }

    override fun getCount(): Int {
        return if (fragments == null) 0 else fragments!!.size
    }

    override fun getPageTitle(position: Int): CharSequence? {
        return if (titles != null && position < titles!!.size) {
            titles!![position]
        } else super.getPageTitle(position)
    }

    fun setTitle(orderMenu: Array<String>?) {
        titles = orderMenu
    }
}