package com.softgarden.baselibrary.base

import android.content.Context
import com.softgarden.baselibrary.network.ApiException
import com.trello.rxlifecycle4.LifecycleTransformer


/**
 * @author by DELL
 * @date on 2020/06/11
 * @describe 用于Activity Fragment 界面交互
 */
interface IBaseDisplay {
    val ctx: Context?
    val baseActivity: BaseActivity<*>?
    val baseFragment:BaseFragment<*>?
    fun showProgressDialog()
    fun showProgressDialog(message: CharSequence?)
    fun hideProgressDialog()
    fun showError(t: Throwable,isConfigStatus:Boolean = true)
    fun onApiException(e: ApiException)
    fun onRequestFinish()

    //    void changeDayNightMode(boolean isNightMode);
    fun <T> bindToLifecycle(): LifecycleTransformer<T?>?
}