package com.softgarden.baselibrary.base


import android.view.View
import androidx.annotation.LayoutRes
import java.util.*

/**
 * @author by DELL
 * @date on 2020/06/11
 * @describe 支持 单选 多选功能的Adapter
 */
abstract class SelectedAdapter<T>(@LayoutRes mLayoutResId: Int) : BaseRVAdapter<T>(mLayoutResId) {
    private var selectMode= true //总开关 开启选择功能
    private var defSelectIndex = 0 //默认单个选中状态
    private var curSelectIndex = 0 //当前单个选中状态
    private var multiSelected = false //是否多选 默认为单选 = false
    val selectedList = ArrayList<Int>() //多选下标集合

    /**
     * 设置开启模式
     *
     * @param isOpen 开启选择模式  默认单选
     */
    fun setSelectMode(isOpen: Boolean) {
        selectMode = isOpen
        notifyDataSetChanged()
        setSelectMode(isOpen, defSelectIndex)
    }

    /**
     * @param isOpen
     * @param defaultIndex 单选的 默认选中下标
     */
    fun setSelectMode(isOpen: Boolean, defaultIndex: Int) {
        selectMode = isOpen
        defSelectIndex = defaultIndex
        curSelectIndex = defSelectIndex
        notifyDataSetChanged()
    }

    /**
     * 设置开启模式
     *
     * @param isOpen        开启选择模式
     * @param multiSelected 是否多选
     */
    fun setSelectMode(isOpen: Boolean, multiSelected: Boolean) {
        selectMode = isOpen
        this.multiSelected = multiSelected
        notifyDataSetChanged()
    }

    /**
     * 默认的选择下标
     *
     * @return
     */
    var defSelectedIndex: Int
        get() = defSelectIndex
        set(index) {
            defSelectIndex = index
            curSelectIndex = defSelectIndex
            notifyDataSetChanged()
        }

    /**
     * 当前的选择下标
     *
     * @return
     */
    var selectedIndex: Int
        get() = curSelectIndex
        set(index) {
            curSelectIndex = index
            notifyDataSetChanged()
        }

    override fun setNewData(data: List<T>?) {
        curSelectIndex = defSelectIndex
        selectedList.clear()
        super.setNewData(data)
    }

    fun clearSelected() {
        curSelectIndex = defSelectIndex
        selectedList.clear()
        notifyDataSetChanged()
    }

    override fun setOnItemClick(v: View, position: Int) {
        setClickSelectState(position)
        super.setOnItemClick(v, position)
    }

    /**
     * 设置选择的状态 需要是可以重写方法
     *
     * @param position
     */
    protected fun setClickSelectState(position: Int) {
        //设置选择器
        if (selectMode) {
            if (multiSelected) {
                if (selectedList.contains(position)) {
                    selectedList.remove(position)
                } else {
                    selectedList.add(position)
                }
            } else {
                if (curSelectIndex > -1) notifyItemChanged(curSelectIndex)
                curSelectIndex = position
            }
            notifyItemChanged(position)
        }
    }

    override fun onBindViewHolder(holder: BaseRVHolder, position: Int) {
        if (selectMode) {
            val isSelected = if (multiSelected) selectedList.contains(position) else curSelectIndex == position //设置状态
            holder.itemView.isSelected = isSelected
        }
        super.onBindViewHolder(holder, position)
    }
}