package com.softgarden.baselibrary.dialog

import android.content.Context
import android.graphics.Color
import android.os.Bundle
import android.text.TextUtils
import android.view.*
import androidx.appcompat.app.AppCompatActivity
import androidx.recyclerview.widget.LinearLayoutManager
import com.chad.library.adapter.base.BaseQuickAdapter
import com.softgarden.baselibrary.R
import com.softgarden.baselibrary.base.*
import com.softgarden.baselibrary.dialog.BottomListDialog
import com.softgarden.baselibrary.widget.ColorDividerDecoration
import kotlinx.android.synthetic.main.dialog_bottom_round.*

/**
 * @author by DELL
 * @date on 2020/06/11
 * @describe
 */
class BottomListDialog : BaseDialogFragment<IBasePresenter>() {
    var bottomListAdapter: BaseRVAdapter<String>? = null
    var hideCancelBtn = false //默认不显示
    var useRoundBackground = false // 是否使用圆角背景
    private var title: String? = null
    var data: List<String?>? = null
//    private var mRecyclerView: RecyclerView? = null
//    private var tvTitle: TextView? = null
//    private var tvCancel: TextView? = null
    override val layoutId: Int
        get() = if (useRoundBackground) R.layout.dialog_bottom_round else R.layout.dialog_bottom

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        //设置dialog在屏幕的位置 不用使其铺满整个屏幕 ，
        // 也解决getDialog().getWindow().setLayout(MATCH_PARENT，MATCH_PARENT）和 setCancelable(true)冲突了
        //该方法只对根布局为LinearLayout 适用
        dialog?.window?.setGravity(Gravity.BOTTOM)
        val lp = dialog?.window?.attributes
        lp?.width = WindowManager.LayoutParams.MATCH_PARENT
        lp?.height = WindowManager.LayoutParams.WRAP_CONTENT
        dialog?.window?.attributes = lp
        dialog?.window?.attributes?.windowAnimations = R.style.dialogAnim
        //使dialog和软键盘可以共存
        dialog?.window?.setFlags(
                WindowManager.LayoutParams.FLAG_ALT_FOCUSABLE_IM,
                WindowManager.LayoutParams.FLAG_ALT_FOCUSABLE_IM)
        return super.onCreateView(inflater, container, savedInstanceState)
    }

    override fun initContentView() {
        super.initContentView()
        dialog?.window?.setLayout(ViewGroup.LayoutParams.MATCH_PARENT,
                ViewGroup.LayoutParams.WRAP_CONTENT)
        isCancelable = true
    }

    override fun initialize() {
        tvTitle!!.text = title
        tvTitle!!.visibility = if (TextUtils.isEmpty(title)) View.GONE else View.VISIBLE
        tvCancel!!.visibility = if (hideCancelBtn) View.GONE else View.VISIBLE
        tvCancel!!.setOnClickListener { dismiss() }
        mRecyclerView!!.addItemDecoration(ColorDividerDecoration(LinearLayoutManager.VERTICAL,
                Color.parseColor("#CCCCCC"), 1, ColorDividerDecoration.Companion.MIDDLE))
        bottomListAdapter =object :BaseRVAdapter<String>(R.layout.item_bottom) {
            override fun onBindVH(holder: BaseRVHolder, data: String, position: Int) {
                holder.setText(R.id.tvContent, data)
            }
        }
        bottomListAdapter?.setNewData(data)
        if (onItemClickListener != null) bottomListAdapter?.onItemClickListener = BaseQuickAdapter.OnItemClickListener { adapter, view, position ->
            onItemClickListener?.onItemClick(this@BottomListDialog, bottomListAdapter?.getItem(position) as String , position)
            dismiss()
        }
        mRecyclerView!!.adapter = bottomListAdapter
    }

    fun setTitle(title: String?): BottomListDialog {
        this.title = title
        return this
    }

    override val baseActivity: BaseActivity<*>?
        get() = activity as BaseActivity<*>

    override val ctx: Context?
        get() = baseActivity

    fun setData(data: List<String?>?): BottomListDialog {
        this.data = data
        return this
    }

    fun hideCancelBtn(): BottomListDialog {
        hideCancelBtn = true
        return this
    }

    fun useRoundBackground(): BottomListDialog {
        useRoundBackground = true
        return this
    }

    fun setOnItemClickListener(onItemClickListener: OnItemClickListener<String>): BottomListDialog {
        this.onItemClickListener = onItemClickListener
        return this
    }

    fun show(activity: AppCompatActivity) {
        this.show(activity.supportFragmentManager, "")
    }

    private var onItemClickListener: OnItemClickListener<String>? = null

    interface OnItemClickListener<T> {
        fun onItemClick(dialog: BottomListDialog?, data: T, position: Int)
    }

    override val baseFragment: BaseFragment<*>?
        get() = null
}