package com.softgarden.baselibrary.dialog

import android.app.ProgressDialog
import android.content.Context
import android.text.TextUtils
import android.view.View
import android.view.WindowManager.BadTokenException
import android.widget.TextView
import androidx.annotation.StringRes
import com.softgarden.baselibrary.R

/**
 * @author by DELL
 * @date on 2020/06/11
 * @describe
 */
class LoadingDialog @JvmOverloads constructor(context: Context?, msg: CharSequence? = "") : ProgressDialog(context, R.style.LoadingDialogStyle) {
    var mLoadingTextView: TextView
    var mView: View
    override fun show() {
        try {
            if (this.isShowing) dismiss() else super.show()
            //setContentView（）一定要在show之后调用
            this.setContentView(mView)
        } catch (exception: BadTokenException) {
        }
    }

    fun setMessage(message: String?) {
        if (!TextUtils.isEmpty(message)) {
            if (mLoadingTextView.visibility != View.VISIBLE) {
                mLoadingTextView.visibility = View.VISIBLE
            }
            mLoadingTextView.text = message
        }
    }

    fun setMessage(@StringRes message: Int) {
        if (mLoadingTextView.visibility != View.VISIBLE) {
            mLoadingTextView.visibility = View.VISIBLE
        }
        mLoadingTextView.setText(message)
    }

    /**
     * 这里的Context 必须用actiivty 不能用applicationContext
     *
     * @param context
     */
    init {
        mView = View.inflate(context, R.layout.dialog_loading, null)
        mLoadingTextView = mView.findViewById<View>(R.id.mLoadingTextView) as TextView
        if (!TextUtils.isEmpty(msg)) {
            mLoadingTextView.text = msg
            mLoadingTextView.visibility = View.VISIBLE
        } else mLoadingTextView.visibility = View.GONE
        setCanceledOnTouchOutside(false)
        setCancelable(true)
    }
}