package com.softgarden.baselibrary.dialog

import android.app.Activity

/**
 * @author by DELL
 * @date on 2020/06/11
 * @describe 加载框的管理类
 */
object LoadingDialogManager {
    private var mCount = 0
    private var mLoadingDialog: LoadingDialog? = null
    fun showLoading(activity: Activity?) {
        if (mCount == 0) {
            mLoadingDialog = LoadingDialog(activity)
            mLoadingDialog!!.setOnCancelListener { mCount = 0 }
            mLoadingDialog!!.show()
        }
        mCount++
    }

    fun showLoading(activity: Activity?, message: CharSequence?) {
        if (mCount == 0) {
            mLoadingDialog = LoadingDialog(activity, message)
            mLoadingDialog!!.setOnCancelListener { mCount = 0 }
            mLoadingDialog!!.show()
        }
        mCount++
    }

    fun dismissLoading() {
        if (mCount == 0) {
            return
        }
        mCount--
        if (mCount == 0) {
            mLoadingDialog!!.dismiss()
            mLoadingDialog = null
        }
    }
}