package com.softgarden.baselibrary.dialog

import android.app.Dialog
import android.content.Context
import android.os.Bundle
import android.text.TextUtils
import android.view.Gravity
import android.view.View
import android.view.WindowManager
import android.widget.ImageView
import android.widget.TextView
import androidx.annotation.ColorRes
import androidx.annotation.DrawableRes
import androidx.core.content.ContextCompat
import com.softgarden.baselibrary.R
import com.softgarden.baselibrary.utils.ScreenUtil

/**
 * @author by DELL
 * @date on 2020/06/11
 * @describe 提示窗  继承自Dialog
 */
class PromptDialog : Dialog, View.OnClickListener {
    var ivIcon: ImageView? = null
    var tvTitle: TextView? = null
    var tvContent: TextView? = null
    var tvPositive: TextView? = null
    var tvNegative: TextView? = null
    private var icon = 0
    private var title: String? = null
    private var content: String? = null
    private var cancelable:Boolean? = false
    private var positiveLabel: String? = null
    private var negativeLabel: String? = null
    private var positiveTextColor = 0
    private var negativeTextColor = 0
    private var useDefaultButton = false
    private var listener: OnButtonClickListener? = null
    private var dimAmount = 0.3f

    constructor(context: Context) : super(context, R.style.CustomDialog)
    constructor(context: Context, themeId: Int) : super(context, themeId)

    override fun onCreate(savedInstanceState: Bundle) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.dialog_prompt)
        window?.setGravity(Gravity.CENTER)
        val params = window?.attributes
        params?.width = (ScreenUtil.Companion.getScreenWidth(context) * 0.75) as Int //设定宽度为屏幕宽度的0.75
        params?.height = WindowManager.LayoutParams.WRAP_CONTENT
        params?.dimAmount = dimAmount //遮罩透明度
        window?.attributes = params
        initView()
    }

    private fun initView() {
        ivIcon = findViewById(R.id.ivIcon)
        tvTitle = findViewById(R.id.tvTitle)
        tvContent = findViewById(R.id.tvContent)
        tvPositive = findViewById(R.id.tvPositive)
        tvNegative = findViewById(R.id.tvNegative)
        tvPositive?.setOnClickListener(this)
        tvNegative?.setOnClickListener(this)
        ivIcon?.setImageResource(icon)
        tvTitle?.text = title
        tvContent?.text = content
        ivIcon?.visibility = if (icon > 0) View.VISIBLE else View.GONE
        tvTitle?.visibility = if (TextUtils.isEmpty(title)) View.GONE else View.VISIBLE
        tvContent?.visibility = if (TextUtils.isEmpty(content)) View.GONE else View.VISIBLE
        if (!useDefaultButton) {
            tvPositive?.text = positiveLabel
            tvNegative?.text = negativeLabel
            tvPositive?.visibility = if (TextUtils.isEmpty(positiveLabel)) View.GONE else View.VISIBLE
            tvNegative?.visibility = if (TextUtils.isEmpty(negativeLabel)) View.GONE else View.VISIBLE
            if (positiveTextColor != 0) tvPositive?.setTextColor(ContextCompat.getColor(context, positiveTextColor))
            if (negativeTextColor != 0) tvNegative?.setTextColor(ContextCompat.getColor(context, negativeTextColor))
        }
        cancelable?.apply {
            setCancelable(this)
        }

    }

    override fun onClick(v: View) {
        if (listener != null) {
            val i = v.id
            if (i == R.id.tvPositive) {
                listener!!.onButtonClick(this, true)
            } else if (i == R.id.tvNegative) {
                listener!!.onButtonClick(this, false)
            }
        }
        dismiss()
    }

    /**
     * 设置图标
     *
     * @param icon
     * @return
     */
    fun setIcon(@DrawableRes icon: Int): PromptDialog {
        this.icon = icon
        return this
    }

    /**
     * 设置标题
     *
     * @param title
     * @return
     */
    fun setTitle(title: String?): PromptDialog {
        this.title = title
        return this
    }

    /**
     * 注意：该方法已弃用
     * 因为返回值类型不同 未能重写该方法
     * 设置标题请使用[.setTitle] 方法
     */
    @Deprecated("")
    override fun setTitle(titleId: Int) {
        //super.setTitle(titleId);
    }

    /**
     * 设置内容
     *
     * @param content
     * @return
     */
    fun setContent(content: String?): PromptDialog {
        this.content = content
        return this
    }

    /**
     * Dialog是否 可以取消
     *
     * @param cancelable
     * @return
     */
    fun setDialogCancelable(cancelable: Boolean): PromptDialog {
        this.cancelable = cancelable
        return this
    }

    /**
     * 是否使用默认的 按钮
     *
     * @return
     */
    fun useDefButton(): PromptDialog {
        useDefaultButton = true
        return this
    }

    /**
     * 设置透明度
     *
     * @param dimAmount 0-1f 透明 - 不透明
     * @return
     */
    fun setDimAmount(dimAmount: Float): PromptDialog {
        this.dimAmount = dimAmount
        return this
    }

    /**
     * 左边的 （默认取消）
     *
     * @param negativeLabel
     * @return
     */
    fun setNegativeButton(negativeLabel: String?, @ColorRes textColorInt: Int): PromptDialog {
        this.negativeLabel = negativeLabel
        negativeTextColor = textColorInt
        return this
    }

    fun setNegativeButton(negativeLabel: String?): PromptDialog {
        this.negativeLabel = negativeLabel
        return this
    }

    /**
     * 右边的 （默认确定）
     *
     * @return
     */
    fun setPositiveButton(positiveLabel: String?, @ColorRes textColorInt: Int): PromptDialog {
        this.positiveLabel = positiveLabel
        positiveTextColor = textColorInt
        return this
    }

    fun setPositiveButton(positiveLabel: String?): PromptDialog {
        this.positiveLabel = positiveLabel
        return this
    }

    fun setOnButtonClickListener(listener: OnButtonClickListener?): PromptDialog {
        this.listener = listener
        return this
    }

    interface OnButtonClickListener {
        /**
         * 当窗口按钮被点击
         *
         * @param dialog
         * @param isPositiveClick true :PositiveButton点击, false :NegativeButton点击
         */
        fun onButtonClick(dialog: PromptDialog?, isPositiveClick: Boolean)
    }
}