package com.softgarden.baselibrary.dialog


import android.text.TextUtils
import android.view.View
import android.view.ViewGroup
import androidx.annotation.ColorRes
import androidx.annotation.DrawableRes
import androidx.appcompat.app.AppCompatActivity
import androidx.core.content.ContextCompat
import com.softgarden.baselibrary.R
import com.softgarden.baselibrary.base.BaseDialogFragment
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.utils.ScreenUtil
import kotlinx.android.synthetic.main.dialog_prompt.*


/**
 * 提示窗  继承自DialogFragment
 *
 * @author by DELL
 * @date on 2020/06/11
 * @describe
 */
abstract class PromptDialogFragment : BaseDialogFragment<IBasePresenter>(), View.OnClickListener {

    private var icon = 0
    private var title: String? = null
    private var content: String? = null
    private var cancelable:Boolean? = false
    private var positiveLabel: String? = null
    private var negativeLabel: String? = null
    private var positiveTextColor = 0
    private var negativeTextColor = 0
    private var useDefaultButton = false
    private var listener: OnButtonClickListener? = null
    override val layoutId: Int
        get() = R.layout.dialog_prompt

    override fun initContentView() {
        super.initContentView()
        val width = (ScreenUtil.Companion.getScreenWidth(context!!) * 0.75) as Int //设定宽度为屏幕宽度的0.75
        dialog?.window?.setLayout(width, ViewGroup.LayoutParams.WRAP_CONTENT)
    }

    override fun initialize() {
        tvPositive!!.setOnClickListener(this)
        tvNegative!!.setOnClickListener(this)
        ivIcon!!.setImageResource(icon)
        tvTitle!!.text = title
        tvContent!!.text = content
        ivIcon!!.visibility = if (icon > 0) View.VISIBLE else View.GONE
        tvTitle!!.visibility = if (TextUtils.isEmpty(title)) View.GONE else View.VISIBLE
        tvContent!!.visibility = if (TextUtils.isEmpty(content)) View.GONE else View.VISIBLE
        if (!useDefaultButton) {
            tvPositive!!.text = positiveLabel
            tvNegative!!.text = negativeLabel
            tvPositive!!.visibility = if (TextUtils.isEmpty(positiveLabel)) View.GONE else View.VISIBLE
            tvNegative!!.visibility = if (TextUtils.isEmpty(negativeLabel)) View.GONE else View.VISIBLE
            context?.apply {
                if (positiveTextColor != 0) tvPositive!!.setTextColor(ContextCompat.getColor(this, positiveTextColor))
                if (negativeTextColor != 0) tvNegative!!.setTextColor(ContextCompat.getColor(this, negativeTextColor))
            }


        }
        cancelable?.apply {
            isCancelable = this
        }
    }

    override fun onClick(v: View) {
        if (listener != null) {
            val i = v.id
            if (i == R.id.tvPositive) {
                listener!!.onButtonClick(this, true)
            } else if (i == R.id.tvNegative) {
                listener!!.onButtonClick(this, false)
            }
        }
        dismiss()
    }

    fun setIcon(@DrawableRes icon: Int): PromptDialogFragment {
        this.icon = icon
        return this
    }

    fun setTitle(title: String?): PromptDialogFragment {
        this.title = title
        return this
    }

    fun setContent(content: String?): PromptDialogFragment {
        this.content = content
        return this
    }

    fun setDialogCancelable(sCancelable: Boolean): PromptDialogFragment {
        this.cancelable = sCancelable
        return this
    }

    fun useDefButton(): PromptDialogFragment {
        useDefaultButton = true
        return this
    }

    /**
     * 左边的 （默认取消）
     *
     * @param negativeLabel
     * @return
     */
    fun setNegativeButton(negativeLabel: String?, @ColorRes textColorInt: Int): PromptDialogFragment {
        this.negativeLabel = negativeLabel
        negativeTextColor = textColorInt
        return this
    }

    fun setNegativeButton(negativeLabel: String?): PromptDialogFragment {
        this.negativeLabel = negativeLabel
        return this
    }

    /**
     * 右边的 （默认确定）
     *
     * @return
     */
    fun setPositiveButton(positiveLabel: String?, @ColorRes textColorInt: Int): PromptDialogFragment {
        this.positiveLabel = positiveLabel
        positiveTextColor = textColorInt
        return this
    }

    fun setPositiveButton(positiveLabel: String?): PromptDialogFragment {
        this.positiveLabel = positiveLabel
        return this
    }

    fun setOnButtonClickListener(listener: OnButtonClickListener?): PromptDialogFragment {
        this.listener = listener
        return this
    }

    /**
     * 显示Dialog
     */
    fun show(activity: AppCompatActivity) {
        this.show(activity.supportFragmentManager, "")
    }

    interface OnButtonClickListener {
        /**
         * 当窗口按钮被点击
         *
         * @param dialog
         * @param isPositiveClick true :PositiveButton点击, false :NegativeButton点击
         */
        fun onButtonClick(dialog: PromptDialogFragment?, isPositiveClick: Boolean)
    }

}