package com.softgarden.baselibrary.glide;

import android.content.Context;


import androidx.annotation.NonNull;

import com.bumptech.glide.Glide;
import com.bumptech.glide.GlideBuilder;
import com.bumptech.glide.Registry;
import com.bumptech.glide.annotation.GlideModule;
import com.bumptech.glide.load.DecodeFormat;
import com.bumptech.glide.module.AppGlideModule;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.ViewTarget;
import com.softgarden.baselibrary.R;


import java.nio.ByteBuffer;

@GlideModule
public class DeGlideModule extends AppGlideModule {

  @Override public void applyOptions(Context context, GlideBuilder builder) {
    // 设置别的get/set tag id，以免占用View默认的
    ViewTarget.setTagId(R.id.glide_custom_view_target_tag);
   // 图片质量低,够用就行
    RequestOptions options = new RequestOptions().format(DecodeFormat.PREFER_RGB_565);
    builder.setDefaultRequestOptions(options);
  }

  @Override
  public void registerComponents(@NonNull Context context, @NonNull Glide glide, @NonNull Registry registry) {
//    glide.getRegistry();
    registry.prepend(String.class, ByteBuffer.class, new ImageLoader.Factory());
  }


}