package com.softgarden.baselibrary.glide;



import androidx.annotation.NonNull;

import com.bumptech.glide.Priority;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.data.DataFetcher;
import com.softgarden.baselibrary.utils.EncodeUtils;


import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.ByteBuffer;

import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class ImageDataFetcher implements DataFetcher<ByteBuffer> {
    private volatile boolean mIsCanceled;
    private String webUrl;

    public ImageDataFetcher(String string) {
        webUrl = string;
    }

    /**
     * 这个方法是在非UI线程中执行,我们利用此方法来加载我们的加密数据
     *
     * @param priority
     * @throws Exception
     */


    @Override
    public void loadData(@NonNull Priority priority, @NonNull DataCallback<? super ByteBuffer> callback) {
        if (mIsCanceled) {
            return;
        }
        OkHttpClient okClient = new OkHttpClient();
//        Request request = new Request.Builder().url("http://agasound.cn/play/long/20200924251/20200924251.jpg.en").build();
        Request request = new Request.Builder().url(webUrl).build();
        try {
            okClient.newCall(request).enqueue(new Callback() {
                @Override
                public void onResponse(Call call, Response response) {
                    // TODO Auto-generated method stub
                    InputStream inputStream = response.body().byteStream();
                    byte[] bytes = new EncodeUtils().decryptUrl(inputStream);
                    ByteBuffer buffer = ByteBuffer.wrap(bytes);
                    callback.onDataReady(buffer);
                }

                @Override
                public void onFailure(Call call, IOException exception) {
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }


    /**
     * 处理完成之后清理工作
     */

    @Override
    public void cleanup() {
//        if (mInputStream != null) {
//            try {
//                mInputStream.close();
//            } catch (IOException e) {
//                Log.e("Glide", "Glide", e);
//            } finally {
//                mInputStream = null;
//            }
//        }
    }


    /**
     * 在UI线程中调用，取消加载任务
     */
    @Override
    public void cancel() {
        mIsCanceled = true;
    }

    @NonNull
    @Override
    public Class<ByteBuffer> getDataClass() {
        return ByteBuffer.class;
    }

    @NonNull
    @Override
    public DataSource getDataSource() {
        return DataSource.REMOTE;
    }
}