package com.softgarden.baselibrary.glide;




import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.model.ModelLoader;
import com.bumptech.glide.load.model.ModelLoaderFactory;
import com.bumptech.glide.load.model.MultiModelLoaderFactory;
import com.bumptech.glide.signature.ObjectKey;
import com.softgarden.baselibrary.utils.Constants;

import java.nio.ByteBuffer;


public class ImageLoader implements ModelLoader<String, ByteBuffer> {

    public ImageLoader() {
    }


    @Nullable
    @Override
    public LoadData<ByteBuffer> buildLoadData(@NonNull String model, int width, int height, @NonNull Options options) {
        return new LoadData(new ObjectKey(model), new ImageDataFetcher(model));
    }

    @Override
    public boolean handles(@NonNull String s) {
        //不带token的.en
        //eg:http://agasound.cn/play/long/2020092783/2020092783.jpg.en
        if (s.endsWith(".en")) {
            return true;
        }
        //带token的.en
        //eg:http://agasound.cn/play/long/2020092783/2020092783.jpg.en?token=FUqxhGjM
        if (s.split("\\?").length > 1) {
            String[] split = s.split("\\?");
            return split[0].endsWith(".en");
        }
        return false;
    }

    /**
     * ModelLoader工厂，在向Glide注册自定义ModelLoader时使用到
     */
    public static class Factory implements ModelLoaderFactory<String, ByteBuffer> {

        @NonNull
        @Override
        public ModelLoader<String, ByteBuffer> build(@NonNull MultiModelLoaderFactory multiFactory) {
            return new ImageLoader();
        }

        @Override
        public void teardown() {

        }


    }
}