package com.softgarden.baselibrary.network

import io.reactivex.rxjava3.core.Observer


/**
 * @author by DELL
 * @date on 2020/06/11
 * @describe 网络请求流程接口
 */
interface Callback<T> : Observer<T> {
    /*** 请求网络开始前，UI线程  */
    fun onStart()

    /*** 对返回数据进行操作的回调， UI线程  */
    fun onSuccess(data: T?)

    /*** 请求失败，响应错误，数据解析错误等，都会回调该方法， UI线程  */
    override fun onError(throwable: Throwable)

    /*** API的异常信息，UI线程  */
    fun onApiException(e: ApiException?)

    /*** 请求网络结束后，UI线程  */
    fun onFinish()
}