package com.softgarden.baselibrary.network

import com.softgarden.baselibrary.base.IBaseDisplay

import io.reactivex.rxjava3.android.schedulers.AndroidSchedulers
import io.reactivex.rxjava3.core.Observable
import io.reactivex.rxjava3.core.ObservableSource
import io.reactivex.rxjava3.core.ObservableTransformer
import io.reactivex.rxjava3.disposables.Disposable
import io.reactivex.rxjava3.schedulers.Schedulers


/**
 * @author by DELL
 * @date on 2020/06/11
 * @describe 无网络加载的Transformer  类似数据库查询
 */
class LocalTransformer<T> @JvmOverloads constructor(mView: IBaseDisplay?, showLoading: Boolean = true) : ObservableTransformer<T?, T> {
    private val mView: IBaseDisplay
    private val showLoading: Boolean
    override fun apply(upstream: Observable<T?>): ObservableSource<T> {
        return upstream
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .doOnSubscribe { disposable: Disposable? ->
                    if (showLoading) {
                        mView.showProgressDialog()
                    }
                } // .doOnTerminate(() -> mView.hideProgressDialog())
                .doFinally {
                    if (showLoading) {
                        mView.hideProgressDialog()
                    }
                }
                .compose(mView.bindToLifecycle())
    }

    init {
        if (mView == null) throw RuntimeException("IBaseDisplay is not NULL")
        this.mView = mView
        this.showLoading = showLoading
    }
}