package com.softgarden.baselibrary.network

import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.utils.NetworkUtil
import io.reactivex.rxjava3.android.schedulers.AndroidSchedulers
import io.reactivex.rxjava3.core.Observable
import io.reactivex.rxjava3.core.ObservableSource
import io.reactivex.rxjava3.core.ObservableTransformer
import io.reactivex.rxjava3.disposables.Disposable
import io.reactivex.rxjava3.functions.Consumer
import io.reactivex.rxjava3.functions.Predicate
import io.reactivex.rxjava3.schedulers.Schedulers


/**
 * @author by DELL
 * @date on 2020/06/11
 * @describe RxJava2 转换器 用于网络加载数据 已实现功能有：
 *
 *
 * 1.检测有无网络
 * 2.加载网络时显示加载框 结束是隐藏
 * 3.控制RxJava生命周期，防止内存泄漏
 */
class NetworkTransformer<T> constructor(mView: IBaseDisplay?, showLoading: Boolean = false,val isConfigStatus:Boolean = true) :
    ObservableTransformer<BaseBean<T>, T> {
    private val mView: IBaseDisplay
    private val showLoading: Boolean
    override fun apply(upstream: Observable<BaseBean<T>>): ObservableSource<T> {
        return upstream
            .subscribeOn(Schedulers.io())
            .observeOn(AndroidSchedulers.mainThread())
            .doOnSubscribe { disposable: Disposable ->
                //请求前检测网络
                if (!NetworkUtil.isConnected(mView.ctx)) {
//                    NetworkUtil.showNoNetWorkDialog(mView.ctx)
//                    mView.onRequestFinish()
                    mView?.showError(Throwable("请检查网络"),isConfigStatus)
                    disposable.dispose()
                } else {
                    if (showLoading) mView.showProgressDialog()
                }
            }
            .doFinally {
                if (showLoading) mView.hideProgressDialog()
                mView.onRequestFinish()
            }
            .filter(filterData())
            .filter(checkInnerData())
            .map {
                it.data
            }
            .doOnError(Consumer { throwable: Throwable ->
                //RxJava2NullException 交给RxCallback处理
                if (throwable !is RxJava3NullException) {
                    mView.showError(throwable,isConfigStatus)
                }
            })
            .compose(mView.bindToLifecycle())


    }

    /**
     * 过滤异常
     *
     * @return
     */
    fun <T> filterData(): Predicate<in BaseBean<T>> {
        return Predicate<BaseBean<T>> {
            if (it.code == BaseBean.SUCCESS) {
                return@Predicate true
            } else {
                //                if (baseBean.status == -1) {
//                    mView.showReLoginDialog();
//                }
                throw ApiException(it.code, it.msg ?: "")
            }
        }
    }

    /**
     * 提取内部真正数据，并检测数据是否为空
     *
     * @return
     */
    fun <T> checkInnerData(): Predicate<in BaseBean<T>> {
        return Predicate<BaseBean<T>> {
            if (it.data != null) {
                return@Predicate true
            }
            throw RxJava3NullException()
        }
    }


//    fun checkInnerData(): Function<in BaseBean<T>, T> {
//        return (label@ Function<BaseBean<T>, T> { baseBean: BaseBean<T> ->
//            if (baseBean.data != null) return@label baseBean.data!!
//            throw RxJava2NullException()
//        })
//    }


    init {
        if (mView == null) throw RuntimeException("IBaseDisplay is not NULL")
        this.mView = mView
        this.showLoading = showLoading
    }
}