package com.softgarden.baselibrary.network

import com.softgarden.baselibrary.base.IBaseDisplay

import io.reactivex.rxjava3.disposables.Disposable

/**
 * @author by DELL
 * @date on 2020/06/11
 * @describe 可直接订阅RxJava 的 Observer 继承类  已实现功能有：
 * 1.对应请求流程，可进行相应的操作
 * 2.捕捉异常，并进行后续操作
 * 3.解决RxJava2不能发生null的问题，当数据传回了Null 则主动进行捕捉并处理
 */
abstract class RxCallback<T> : Callback<T> {
    private val mView: IBaseDisplay? = null

    //    public RxCallback(IBaseDisplay mView) {
    //        this.mView = mView;
    //    }
    override fun onSubscribe(d: Disposable) {
        onStart()
    }

    override fun onStart() {}
    override fun onNext(t: T) {
        onSuccess(t)
//        onComplete()
    }

    override fun onError(t: Throwable) {
        if (t is RxJava3NullException) {
            //RxJava2不能发送null
            onSuccess(null)
        } else if (t is ApiException) {
            //通用的Api异常处理
            onApiException(t)
        } else {

        }
        onComplete()
    }

    override fun onApiException(e: ApiException?) {
        //默认 需要根据业务逻辑 处理了
//        ToastUtil.s(e.getMessage());
//        e.printStackTrace();
    }

    override fun onComplete() {
        onFinish()
    }

    override fun onFinish() {}
}