package com.softgarden.baselibrary.utils

import android.os.Build
import android.text.TextUtils
import android.util.Base64
import java.io.UnsupportedEncodingException
import java.nio.charset.Charset
import java.security.Provider
import java.security.SecureRandom
import javax.crypto.Cipher
import javax.crypto.KeyGenerator
import javax.crypto.spec.IvParameterSpec
import javax.crypto.spec.SecretKeySpec

/**
 * @author by DELL
 * @date on 2020/06/11
 * @describe
 */
object AESUtil {
    /**
     * 算法/模式/填充
     */
    private const val CipherMode = "AES/CBC/PKCS5Padding"
    const val IV = "1234567887654321"

    /**
     * 公钥加密
     *
     * @param contentStr
     * @param key  得到的公钥
     * @param iv
     * @return 已被Base64加密过的字符串
     */
    fun encrypt(contentStr: String, key: String, iv: String): String? {
        var key = key
        key = getPassword(key) //截取key 16位
        try {
            val strByte = contentStr.toByteArray(charset("UTF-8"))
            val keyByte = key.toByteArray(charset("UTF-8"))
            val ivByte = iv.toByteArray(charset("UTF-8"))
            val result = encrypt(strByte, keyByte, ivByte) //AES加密
            return Base64.encodeToString(result, Base64.NO_PADDING) //要进行base64再一次加密
        } catch (e: UnsupportedEncodingException) {
            e.printStackTrace()
        }
        return null
    }

    /**
     * 私钥解密
     *
     * @param base64Str
     * @param key
     * @param iv
     * @return
     */
    fun decryptWithBase64(base64Str: String?, key: String, iv: String): String? {
        var key = key
        key = getPassword(key) //截取key 16位
        try {
            val strByte = Base64.decode(base64Str, Base64.NO_PADDING) //要先base64解密
            val keyByte = key.toByteArray(charset("UTF-8"))
            val ivByte = iv.toByteArray(charset("UTF-8"))
            val result = decrypt(strByte, keyByte, ivByte) //AES解密
            return String(result!!, Charset.defaultCharset())
        } catch (e: UnsupportedEncodingException) {
            e.printStackTrace()
        }
        return null
    }

    /**
     * 获取16位的秘钥（128 bits）
     * 长度大于16则截取前16位，否则不变（这是错的，因为 128要求必须有16位密码）
     *
     * @param key
     * @return
     */
    private fun getPassword(key: String): String {
        if (TextUtils.isEmpty(key)) return "0000000000000000" //这是错的，因为 128要求必须有16位密码
        return if (key.length >= 16) {
            key.substring(0, 16) //长度大于16则截取前16位
        } else {
            key //这是错的，因为 128要求必须有16位密码
        }
    }

    fun encrypt(content: ByteArray?, keyBytes: ByteArray?, iv: ByteArray?): ByteArray? {
        try {
//            byte[] raw = getRawKey(keyBytes);
            val key = SecretKeySpec(keyBytes, "AES")
            val cipher = Cipher.getInstance(CipherMode)
            cipher.init(Cipher.ENCRYPT_MODE, key, IvParameterSpec(iv))
            return cipher.doFinal(content)
        } catch (e: Exception) {
            e.printStackTrace()
        }
        return null
    }

    fun decrypt(content: ByteArray?, keyBytes: ByteArray?, iv: ByteArray?): ByteArray? {
        try {
//            byte[] raw = getRawKey(keyBytes);
//            SecretKeySpec key = new SecretKeySpec(raw, "AES");
            val key = SecretKeySpec(keyBytes, "AES")
            val cipher = Cipher.getInstance(CipherMode)
            cipher.init(Cipher.DECRYPT_MODE, key, IvParameterSpec(iv))
            return cipher.doFinal(content)
        } catch (e: Exception) {
            e.printStackTrace()
        }
        return null
    }

    // 对密钥进行处理
    @Throws(Exception::class)
    private fun getRawKey(seed: ByteArray): ByteArray {
        val kgen = KeyGenerator.getInstance("AES")
        //for android
        var sr: SecureRandom? = null
        val sdk_version = Build.VERSION.SDK_INT
        sr = if (sdk_version > 23) {  // Android  6.0 以上
            SecureRandom.getInstance("SHA1PRNG", CryptoProvider())
        } else if (sdk_version >= 17) {
            SecureRandom.getInstance("SHA1PRNG", "Crypto")
        } else {
            SecureRandom.getInstance("SHA1PRNG")
        }

        // for Java
        // secureRandom = SecureRandom.getInstance(SHA1PRNG);
        sr.setSeed(seed)
        kgen.init(128, sr) //256 bits or 128 bits,192bits
        //AES中128位密钥版本有10个加密循环，192比特密钥版本有12个加密循环，256比特密钥版本则有14个加密循环。
        val skey = kgen.generateKey()
        return skey.encoded
    }

    /**
     * 将二进制转换成16进制
     *
     * @param buf
     * @return
     */
    fun parseByte2HexStr(buf: ByteArray): String {
        val sb = StringBuffer()
        for (i in buf.indices) {
            var hex = Integer.toHexString(buf[i].toInt() and 0xFF)
            if (hex.length == 1) {
                hex = "0$hex"
            }
            sb.append(hex.toUpperCase())
        }
        return sb.toString()
    }

    /**
     * 把16进制字符串转换成字节数组
     *
     * @param hex
     * @return byte[]
     */
    fun hexStringToBytes(hex: String): ByteArray {
        val len = hex.length / 2
        val result = ByteArray(len)
        val achar = hex.toCharArray()
        for (i in 0 until len) {
            val pos = i * 2
            result[i] = (toByte(achar[pos]) shl 4 or toByte(achar[pos + 1])).toByte()
        }
        return result
    }

    private fun toByte(c: Char): Int {
        val b = "0123456789ABCDEF".indexOf(c).toByte()
        return b.toInt()
    }

    /**
     * 数组转换成十六进制字符串
     *
     * @param bArray
     * @return HexString
     */
    fun bytesToHexString(bArray: ByteArray): String {
        val sb = StringBuffer(bArray.size)
        var sTemp: String
        for (i in bArray.indices) {
            sTemp = Integer.toHexString(0xFF and bArray[i].toInt())
            if (sTemp.length < 2) sb.append(0)
            sb.append(sTemp.toUpperCase())
        }
        return sb.toString()
    }

    /**
     * 将16进制转换为二进制
     *
     * @param hexStr
     * @return
     */
    fun parseHexStr2Byte(hexStr: String): ByteArray? {
        if (hexStr.length < 1) return null
        val result = ByteArray(hexStr.length / 2)
        for (i in 0 until hexStr.length / 2) {
            val high = hexStr.substring(i * 2, i * 2 + 1).toInt(16)
            val low = hexStr.substring(i * 2 + 1, i * 2 + 2).toInt(
                    16)
            result[i] = (high * 16 + low).toByte()
        }
        return result
    }

    private fun toHex(buf: ByteArray?): String {
        val HEX = "0123456789ABCDEF"
        if (buf == null) return ""
        val result = StringBuffer(2 * buf.size)
        for (i in buf.indices) {
            result.append(HEX[buf[i] .toInt()shr 4 and 0x0f]).append(
                    HEX[buf[i].toInt() and 0x0f])
        }
        return result.toString()
    }

    private fun toByte(hexString: String): ByteArray {
        val len = hexString.length / 2
        val result = ByteArray(len)
        for (i in 0 until len) result[i] = Integer.valueOf(hexString.substring(2 * i, 2 * i + 2),
                16).toByte()
        return result
    }

    //    public static void main(String[] args) throws UnsupportedEncodingException {
    //        String IV = "1750654920105581";
    //        String API_ENCRYPT_KEY = "1467f4699214cec412f7c2a1d513fe08";
    //        String data = "b+W8eZv9suf1DgHEzeny5DtAPrd4L5dBHHL+0YF85ey2W\\/oFX9sBVD3azJkOP\\/M0BXUJu7f0eiQLi2oIbz56LOC1Pto1qVx3dgg\\/agidWTU=";
    //        System.out.println(data);
    //        System.out.println(data.getBytes("UTF-8"));
    //        try {
    //
    //            String key = MD5Util.ToMD5NOKey("1522220376" + API_ENCRYPT_KEY + "e879ada9061d176a498812c62770b9c3");
    //            // byte[] en = encrypt(data.getBytes("UTF-8"), API_ENCRYPT_KEY.getBytes("UTF-8"), IV.getBytes("UTF-8"));
    //            System.out.println("key==" + key);
    //            byte[] bytes = java.util.Base64.getDecoder().decode(data);
    //            System.out.println("解密后数据==" + new String(decrypt(bytes, key.getBytes("UTF-8"), IV.getBytes("UTF-8")), "UTF-8"));
    //
    //        } catch (Exception e) {
    //            e.printStackTrace();
    //        }
    //
    //
    //    }
    class CryptoProvider : Provider("Crypto", 1.0, "HARMONY (SHA1 digest; SecureRandom; SHA1withDSA signature)") {
        /**
         * Creates a Provider and puts parameters
         */
        init {
            put("SecureRandom.SHA1PRNG",
                    "org.apache.harmony.security.provider.crypto.SHA1PRNG_SecureRandomImpl")
            put("SecureRandom.SHA1PRNG ImplementedIn", "Software")
        }
    }
}