package com.softgarden.baselibrary.utils

import com.softgarden.baselibrary.BaseApplication
import java.util.*

/**
 * @author by DELL
 * @date on 2020/06/11
 * @describe SharedPreferences 数据保存管理类
 */
open class BaseSPManager {
    companion object {
        const val FOLLOW_SYSTEM_LANGUAGE = "follow_system_language" //语言
        const val LANGUAGE = "language" //语言
        const val LANGUAGE_COUNTRY = "language_country" //语言_国家地区

        //    public static final String DAY_NIGHT_MODE = "day_night_mode";//日夜模式
        const val IS_FIRST_LAUNCH = "is_first_launch" //是否第一次启动
        const val VERSION_CODE = "version_code" //版本号

        /*** 是否跟随系统  */
        var isFollowSystemLanguage: Boolean
            get() = SPUtil.Companion.get(FOLLOW_SYSTEM_LANGUAGE, true) as Boolean
            set(isFollow) {
                SPUtil.Companion.put(FOLLOW_SYSTEM_LANGUAGE, isFollow)
            }//默认简体中文//默认简体中文

        /***  语言 默认系统语言 */
        var language: Locale
            get() {
                val isSystem = isFollowSystemLanguage
                if (isSystem) return Locale.getDefault()
                val language = SPUtil.Companion.get(LANGUAGE, Locale.getDefault().language) as String //默认简体中文
                val country = SPUtil.Companion.get(LANGUAGE_COUNTRY, Locale.getDefault().country) as String //默认简体中文
                return Locale(language, country)
            }
            set(language) {
                SPUtil.Companion.put(LANGUAGE, language.language)
                SPUtil.Companion.put(LANGUAGE_COUNTRY, language.country)
            }

        //    /*** 日夜模式 */
        //    public static boolean isNightMode() {
        //        return (boolean) SPUtil.get(DAY_NIGHT_MODE, false);
        //    }
        //
        //    public static void setNightMode(boolean nightMode) {
        //        SPUtil.put(DAY_NIGHT_MODE, nightMode);
        //    }
        /*** 是否第一次启动  */
        var isFirstLaunch: Boolean
            get() = SPUtil.Companion.get(IS_FIRST_LAUNCH, true) as Boolean
            set(isFirstLunch) {
                SPUtil.Companion.put(IS_FIRST_LAUNCH, isFirstLunch)
            }

        /*** 是否新版本  */
        val isNewVersion: Boolean
            get() {
                val versionCode = SPUtil.Companion.get(VERSION_CODE, 0) as Int
                val curCode: Int = AppUtil.Companion.getPackageInfo(BaseApplication.Companion.instance)!!.versionCode
                return curCode > versionCode
            }

        fun updateVersionCode() {
            val curCode: Int = AppUtil.Companion.getPackageInfo(BaseApplication.Companion.instance)!!.versionCode
            SPUtil.Companion.put(VERSION_CODE, curCode)
        }
    }
}