package com.softgarden.baselibrary.utils

import android.text.TextUtils

/**
 * @author by DELL
 * @date on 2020/06/11
 * @describe
 */
object CheckUtil {
    fun isEmpty(str: String?, hint: String?): Boolean {
        if (TextUtils.isEmpty(str)) {
            ToastUtil.Companion.s(hint)
            return true
        }
        return false
    }

    fun isNotEmpty(str: String?, hint: String?): Boolean {
        return !isEmpty(str, hint)
    }

    fun isNotEquals(str1: String?, str2: String?, hint: String?): Boolean {
        if (!TextUtils.equals(str1, str2)) {
            ToastUtil.Companion.s(hint)
            return true
        }
        return false
    }

    fun isEquals(str1: String?, str2: String?, hint: String?): Boolean {
        if (TextUtils.equals(str1, str2)) {
            ToastUtil.Companion.s(hint)
            return true
        }
        return false
    }

    /**
     * 密码是否非法 6位以上数字或数字+字母
     *
     * @param str
     * @param hint
     * @return
     */
    fun isIllegalPwd(str: String, hint: String?): Boolean {
        if (TextUtils.isEmpty(str)) {
            ToastUtil.Companion.s(hint)
            return true
        }

//        if (!Pattern.matches("^[a-zA-Z0-9]{6,}$", str)) {
//            ToastUtil.s(hint);
//            return true;
//        }
        //这里只判断了长度 任意字符都可以
        if (str.length < 6 || str.contains(" ")) {
            ToastUtil.Companion.s(hint)
            return true
        }
        return false
    }

    /**
     * 邮箱是否非法
     *
     * @param str
     * @param hint
     * @return
     */
    fun isIllegalEmail(str: String?, hint: String?): Boolean {
        if (TextUtils.isEmpty(str)) {
            ToastUtil.Companion.s(hint)
            return true
        }
        if (!RegularUtil.Companion.isEmail(str)) {
            ToastUtil.Companion.s(hint)
            return true
        }
        return false
    }

    fun isIllegalIDCard(str: String?, hint: String?): Boolean {
        if (TextUtils.isEmpty(str)) {
            ToastUtil.Companion.s(hint)
            return true
        }
        if (!RegularUtil.Companion.isIDCard18(str)) {
            ToastUtil.Companion.s(hint)
            return true
        }
        return false
    }

    /**
     * 手机号码是否非法
     *
     * @param str
     * @param hint
     * @return
     */
    fun isIllegalPhone(str: String?, hint: String?): Boolean {
        if (TextUtils.isEmpty(str)) {
            ToastUtil.Companion.s(hint)
            return true
        }
        if (!RegularUtil.Companion.isMobileSimple(str)) {
            ToastUtil.Companion.s(hint)
            return true
        }
        return false
    }
}