package com.softgarden.baselibrary.utils

/**
 * @author by DELL
 * @date on 2020/06/11
 * @describe
 * 判断 列表是否为空
 * 判断 字符串是否为空
 * 判断 数字是否为0
 */
class EmptyUtil private constructor() {
    companion object {
        /**
         * 列表是否为空
         *
         * @param list
         * @return
         */
        fun isEmpty(list: List<*>?): Boolean {
            return list == null || list.isEmpty()
        }

        fun isNotEmpty(list: List<*>?): Boolean {
            return !isEmpty(list)
        }

        /**
         * 字符串是否为空
         *
         * @param str
         * @return
         */
        fun isEmpty(str: CharSequence?): Boolean {
            return str == null || str.length == 0
        }

        fun isNotEmpty(str: CharSequence?): Boolean {
            return !isEmpty(str)
        }

        fun nullIfEmpty(str: String?): String? {
            return if (isEmpty(str)) null else str
        }

        /**
         * 是否为0
         *
         * @param numStr
         * @return
         */
        fun isFloatZero(numStr: String?): Boolean {
            if (numStr == null) return true //为空时也当成0
            val n: Float
            n = try {
                java.lang.Float.valueOf(numStr)
            } catch (e: NumberFormatException) {
                return false
            }
            return n == 0f
        }

        fun isNotFloatZero(numStr: String?): Boolean {
            return !isFloatZero(numStr)
        }

        fun isIntZero(numStr: String?): Boolean {
            if (numStr == null) return true //为空时也当成0
            val n: Int
            n = try {
                Integer.valueOf(numStr)
            } catch (e: NumberFormatException) {
                return false
            }
            return n == 0
        }

        fun isNotIntZero(numStr: String?): Boolean {
            return !isIntZero(numStr)
        }
    }

    init {
        throw UnsupportedOperationException("u can`t fuck me...")
    }
}