package com.softgarden.baselibrary.utils

/**
 * @author by DELL
 * @date on 2020/06/11
 * @describe
 */
object InstanceUtil {
    /**
     * 通过实例工厂去实例化相应类
     *
     * @param <T> 返回实例的泛型类型
     * @return
    </T> */
    fun <T> getInstance(clazz: Class<*>): T? {
        try {
            return clazz.newInstance() as T
        } catch (e: InstantiationException) {
            e.printStackTrace()
        } catch (e: IllegalAccessException) {
            e.printStackTrace()
        }
        return null
    }

    @Throws(IllegalAccessException::class, InstantiationException::class)
    fun create(mClass: Class<*>): Any {
        return when (mClass.simpleName) {
            else -> mClass.newInstance()
        }
    }
}