package com.softgarden.baselibrary.utils

import android.annotation.TargetApi
import android.content.Context
import android.os.Build
import android.os.LocaleList
import java.util.*

/**
 * @author by DELL
 * @date on 2020/06/11
 * @describe
 */
object LanguageUtil {
    /**
     * 应用语言
     *
     * @param context 此context必须和[.attachBaseContext] 中的context一致 ，否则切换会失效
     * @param locale
     */
    fun switchLanguage(context: Context, locale: Locale?) {
        //应用内配置语言
        val resources = context.resources //获得res资源对象
        val config = resources.configuration //获得设置对象
        val dm = resources.displayMetrics //获得屏幕参数：主要是分辨率，像素等。
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
            config.setLocale(locale)
        } else {
            config.locale = locale
        }
        resources.updateConfiguration(config, dm)
    }

    fun getLanguage(context: Context): Locale {
        //应用内配置语言
        val resources = context.resources //获得res资源对象
        val config = resources.configuration //获得设置对象
        return if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
            config.locales[0]
        } else {
            config.locale
        }
    }

    /**
     * 获取对应的context
     *
     * @param context
     * @param locale
     * @return
     */
    fun attachBaseContext(context: Context, locale: Locale?): Context {
        //8.0 updateConfiguration 失效  用createConfigurationContext 代替
        return if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
            createConfigurationResources(context, locale)
        } else {
            context
        }
    }

    /**
     * 8.0 配置语言方法
     *
     * @param context
     * @param locale
     * @return
     */
    @TargetApi(Build.VERSION_CODES.N)
    private fun createConfigurationResources(context: Context, locale: Locale?): Context {
        val resources = context.resources
        val configuration = resources.configuration
        configuration.setLocale(locale)
//        configuration.locales = LocaleList(locale)
        return context.createConfigurationContext(configuration)
    }
}