package com.softgarden.baselibrary.utils

import android.content.Context
import android.net.ConnectivityManager
import com.softgarden.baselibrary.R
import com.softgarden.baselibrary.dialog.PromptDialog
import com.softgarden.baselibrary.dialog.PromptDialog.OnButtonClickListener

/**
 * @author by DELL
 * @date on 2020/06/11
 * @describe 类描述：判断网络是否可以连接工具类
 */
object NetworkUtil {
    /**
     * 判断网络连接是否已开
     * true 已打开  false 未打开
     *
     * @param context
     * @return
     */
    fun isConnected(context: Context?): Boolean {
        var isConnected = false
        val conManager = context!!.getSystemService(Context.CONNECTIVITY_SERVICE) as ConnectivityManager
        val network = conManager.activeNetworkInfo
        if (network != null && conManager.activeNetworkInfo != null) {
            isConnected = conManager.activeNetworkInfo.isAvailable
        }
        return isConnected
    }

    /**
     * 判断是否是WIFI连接
     *
     * @param context
     * @return
     */
    fun isWIFI(context: Context): Boolean {
        val connectivityManager = context.getSystemService(Context.CONNECTIVITY_SERVICE) as ConnectivityManager
        return if (connectivityManager == null || connectivityManager.activeNetworkInfo == null) false else connectivityManager.activeNetworkInfo.type == ConnectivityManager.TYPE_WIFI
    }

    @Volatile
    private var promptDialog: PromptDialog? = null

    /**
     * 当判断当前手机没有网络时选择是否打开网络设置
     *
     * @param context
     */
    fun showNoNetWorkDialog(context: Context?) {
        if (promptDialog == null) {
            synchronized(PromptDialog::class.java) {
                if (promptDialog == null) {
                    context?.let {
                        promptDialog = PromptDialog(it)
                                .setTitle(it.getString(R.string.base_warm_hint))
                                .setContent(it.getString(R.string.base_no_network_hint))
                                .setPositiveButton(it.getString(R.string.base_go))
                                .setNegativeButton(it.getString(R.string.base_cancel))
                                .setOnButtonClickListener(object : OnButtonClickListener{
                                    override fun onButtonClick(dialog: PromptDialog?, isPositiveClick: Boolean) {
                                        if (isPositiveClick) AppUtil.Companion.openNetworkSetting(it) //前往设置界面
                                    }
                                })
                    }
                    promptDialog?.setOnDismissListener {
                        promptDialog = null }
                    promptDialog?.setOnCancelListener {
                        promptDialog = null }
                    //  promptDialog.show();
                }
            }
        }
        promptDialog!!.show()
    }
}