package com.softgarden.baselibrary.utils

import android.util.Base64
import android.util.Log
import java.io.UnsupportedEncodingException
import java.nio.charset.Charset
import java.security.KeyFactory
import java.security.KeyPair
import java.security.KeyPairGenerator
import java.security.NoSuchAlgorithmException
import java.security.interfaces.RSAPrivateKey
import java.security.interfaces.RSAPublicKey
import java.security.spec.PKCS8EncodedKeySpec
import java.security.spec.X509EncodedKeySpec
import java.util.*
import javax.crypto.Cipher

/**
 * @author by DELL
 * @date on 2020/06/11
 * @describe
 */
class RSAUtil {
    private var keyPair: KeyPair? = null

    //获取公钥
    val publicByKey:
            //公钥用base64编码
            //        Log.d("TAG", "base64编码的公钥：" + encodePublic);
            String
        get() {
            //获取公钥
            val publicKey = getPublicKey(hashMap[urlKey])
            //公钥用base64编码
            //        Log.d("TAG", "base64编码的公钥：" + encodePublic);
            return Base64.encodeToString(publicKey, Base64.DEFAULT)
        }

    //获取公钥
    val publicKey:
            //公钥用base64编码
            //        Log.d("TAG", "base64编码的公钥：" + encodePublic);
            String
        get() {
            //获取公钥
            val publicKey = getPublicKey(keyPair)
            //公钥用base64编码
            //        Log.d("TAG", "base64编码的公钥：" + encodePublic);
            return Base64.encodeToString(publicKey, Base64.DEFAULT)
        }

    //获取私钥
    val privateByKey:
            //私钥用base64编码
            //        Log.d("TAG", "base64编码的私钥：" + encodePrivate);
            String
        get() {
            //获取私钥
            val privateKey = getPrivateKey(hashMap[urlKey])
            //私钥用base64编码
            //        Log.d("TAG", "base64编码的私钥：" + encodePrivate);
            return Base64.encodeToString(privateKey, Base64.DEFAULT)
        }

    //获取私钥
    val privateKey:
            //私钥用base64编码
            //        Log.d("TAG", "base64编码的私钥：" + encodePrivate);
            String
        get() {
            //获取私钥
            val privateKey = getPrivateKey(keyPair)
            //私钥用base64编码
            //        Log.d("TAG", "base64编码的私钥：" + encodePrivate);
            return Base64.encodeToString(privateKey, Base64.DEFAULT)
        }

    private fun test() {
        val keyLength = 1024
        try {
            //生成密钥对
            val keyPair = generateRSAKeyPair(keyLength)

            //获取公钥
            val publicKey = getPublicKey(keyPair)
            //公钥用base64编码
            val encodePublic = Base64.encodeToString(publicKey, Base64.DEFAULT)
            L.d("TAG", "base64编码的公钥：$encodePublic")

            //获取私钥
            val privateKey = getPrivateKey(keyPair)
            //私钥用base64编码
            val encodePrivate = Base64.encodeToString(privateKey, Base64.DEFAULT)
            L.d("TAG", "base64编码的私钥：$encodePrivate")
        } catch (e: NoSuchAlgorithmException) {
            e.printStackTrace()
        }
    }

    companion object {
        private const val RSA = "RSA"
        private const val UTF_8 = "UFT-8"
        private const val TRANSFORMATION = "RSA/None/PKCS1Padding"

        //    private static KeyPair keyPair;
        private const val keyLength = 1024
        var hashMap = HashMap<String?, KeyPair>()
        var urlKey: String? = null

        /**
         * 生成密钥对，即公钥和私钥。key长度是512-2048，一般为1024
         */
        @Throws(NoSuchAlgorithmException::class)
        private fun generateRSAKeyPair(keyLength: Int): KeyPair {
            val kpg = KeyPairGenerator.getInstance(RSA)
            kpg.initialize(keyLength)
            return kpg.genKeyPair()
        }

        /**
         * 获取公钥，打印为48-12613448136942-12272-122-913111503-126115048-12...等等一长串用-拼接的数字
         */
        private fun getPublicKey(keyPair: KeyPair?): ByteArray {
            val rsaPublicKey = keyPair!!.public as RSAPublicKey
            return rsaPublicKey.encoded
        }

        /**
         * 获取私钥，同上
         */
        private fun getPrivateKey(keyPair: KeyPair?): ByteArray {
            val rsaPrivateKey = keyPair!!.private as RSAPrivateKey
            return rsaPrivateKey.encoded
        }

        /**
         * 使用公钥加密
         *
         * @param data
         * @param base64PublicKey
         * @return
         * @throws Exception
         */
        fun encryptWithBase64(data: String, base64PublicKey: String?): String? {
            try {
                val bytes = data.toByteArray(charset("UTF-8"))
                val publicKey = Base64.decode(base64PublicKey, Base64.DEFAULT)
                val encrypted = encrypt(bytes, publicKey)
                return Base64.encodeToString(encrypted, Base64.DEFAULT)
            } catch (e: UnsupportedEncodingException) {
                e.printStackTrace()
            } catch (e: Exception) {
                e.printStackTrace()
            }
            return null
        }

        /**
         * 使用公钥加密
         */
        @Throws(Exception::class)
        fun encrypt(data: ByteArray?, publicKey: ByteArray?): ByteArray {
            // 得到公钥对象
            val keySpec = X509EncodedKeySpec(publicKey)
            val keyFactory = KeyFactory.getInstance(RSA)
            val pubKey = keyFactory.generatePublic(keySpec)
            // 加密数据
            val cp = Cipher.getInstance(TRANSFORMATION)
            cp.init(Cipher.ENCRYPT_MODE, pubKey)
            return cp.doFinal(data)
        }

        /**
         * 使用私钥解密
         *
         * @param base64Str        密文内容
         * @param base64PrivateKey 秘钥内容
         * @return
         * @throws Exception
         */
        fun decryptWithBase64(base64Str: String?, base64PrivateKey: String?): String? {
            val encrypted = Base64.decode(base64Str, Base64.DEFAULT) //密文要先base64解密
            val privateKey = Base64.decode(base64PrivateKey, Base64.DEFAULT) //秘钥要先base64解密
            try {
                return String(decrypt(encrypted, privateKey), Charset.defaultCharset())
            } catch (e: Exception) {
                e.printStackTrace()
            }
            return null
        }

        /**
         * 使用私钥解密
         *
         * @param encrypted  密文内容
         * @param privateKey 秘钥内容
         * @return
         * @throws Exception
         */
        @Throws(Exception::class)
        fun decrypt(encrypted: ByteArray?, privateKey: ByteArray?): ByteArray {
            // 得到私钥对象
            val keySpec = PKCS8EncodedKeySpec(privateKey)
            val kf = KeyFactory.getInstance(RSA)
            val keyPrivate = kf.generatePrivate(keySpec)
            // 解密数据
            val cp = Cipher.getInstance(TRANSFORMATION)
            cp.init(Cipher.DECRYPT_MODE, keyPrivate)
            return cp.doFinal(encrypted)
        }
    }

    init {
        try {
            if (keyPair == null) {
                keyPair = generateRSAKeyPair(keyLength)
            }
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }
}