package com.softgarden.baselibrary.utils

import android.app.Activity
import android.content.Context

import androidx.recyclerview.widget.RecyclerView
import android.util.DisplayMetrics
import android.view.ViewGroup
import android.widget.LinearLayout
import androidx.annotation.ColorRes
import androidx.core.content.ContextCompat
import androidx.recyclerview.widget.GridLayoutManager
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.OrientationHelper
import com.softgarden.baselibrary.utils.DisplayUtil.dip2px
import com.softgarden.baselibrary.widget.ColorDividerDecoration
import com.softgarden.baselibrary.widget.GridDividerDecoration
import com.softgarden.baselibrary.widget.GridDividerHeaderDecoration
import com.softgarden.baselibrary.widget.GridDividerStarDecoration

/**
 * @author by DELL
 * @date on 2020/06/11
 * @describe
 */
object RecyclerViewUtil {
    /**
     * 设置自适应高度
     * @param recyclerView
     * @param layoutManager
     */
    fun autoFixHeight(recyclerView: RecyclerView, layoutManager: LinearLayoutManager) {
        layoutManager.isSmoothScrollbarEnabled = true
        layoutManager.isAutoMeasureEnabled = true
        recyclerView.layoutManager = layoutManager
        recyclerView.setHasFixedSize(true)
        recyclerView.isNestedScrollingEnabled = false
    }

    /**
     * 将RecyclerView的item均分成几分
     * @param context context
     * @param averageNum 均分为几份
     * @param layoutMargin 父布局的padding或者margin
     * @param itemDivider item的分割线距离
     */
    fun averageItem(context:Context,averageNum:Int,layoutMargin:Float,itemDivider:Int):LinearLayout.LayoutParams{
        val displayMetrics: DisplayMetrics = context.resources.displayMetrics
        val widthPixels = (displayMetrics.widthPixels - dip2px(context, layoutMargin + itemDivider * averageNum)) /averageNum
        return LinearLayout.LayoutParams(widthPixels, ViewGroup.LayoutParams.MATCH_PARENT)
    }

     fun addItemDecoration(activity:Activity,recyclerView: RecyclerView, @ColorRes id: Int, dp: Int, mOrientation :Int = OrientationHelper.VERTICAL) {
         recyclerView.addItemDecoration(ColorDividerDecoration(mOrientation, ContextCompat.getColor(activity, id), dip2px(activity, dp.toFloat())))
    }
    fun addItemDecoration(activity:Activity,recyclerView: RecyclerView, @ColorRes id: Int, dp: Float, mOrientation :Int = OrientationHelper.VERTICAL) {
         recyclerView.addItemDecoration(ColorDividerDecoration(mOrientation, ContextCompat.getColor(activity, id), dip2px(activity, dp)))
    }
    fun addItemDecorationPx(activity:Activity,recyclerView: RecyclerView, @ColorRes id: Int, px: Int, mOrientation :Int = OrientationHelper.VERTICAL) {
         recyclerView.addItemDecoration(ColorDividerDecoration(mOrientation, ContextCompat.getColor(activity, id), px))
    }
     fun addGridItemDecoration(activity:Activity, recyclerView: RecyclerView, @ColorRes id: Int, dp: Int) {
         recyclerView.addItemDecoration(GridDividerDecoration(dip2px(activity, dp.toFloat()),ContextCompat.getColor(activity, id)))
    }
    fun addGridItemHeaderDecoration(activity:Activity,recyclerView: RecyclerView,@ColorRes id: Int, dp: Int) {
         recyclerView.addItemDecoration(GridDividerHeaderDecoration(dip2px(activity, dp.toFloat()),ContextCompat.getColor(activity, id)))
    }
    fun addGridItemStarDecoration(activity:Activity,recyclerView: RecyclerView,@ColorRes id: Int, dp: Int) {
         recyclerView.addItemDecoration(GridDividerStarDecoration(dip2px(activity, dp.toFloat()),ContextCompat.getColor(activity, id)))
    }

    /**
     * 解决嵌套NestScrollView会卡顿的问题
     */
    fun nestedScrollNoFluent(recyclerView: RecyclerView,layoutManager: GridLayoutManager):GridLayoutManager{
        recyclerView.isNestedScrollingEnabled =false
        recyclerView.setHasFixedSize(true)
        layoutManager.isSmoothScrollbarEnabled=true
        layoutManager.isAutoMeasureEnabled = true
        return layoutManager
    }

   fun nestedScrollNoFluent(recyclerView: RecyclerView,layoutManager:LinearLayoutManager):LinearLayoutManager{
        recyclerView.isNestedScrollingEnabled =false
        recyclerView.setHasFixedSize(true)
        layoutManager.isSmoothScrollbarEnabled=true
        layoutManager.isAutoMeasureEnabled = true
        return layoutManager
    }
}