package com.softgarden.baselibrary.utils

/**
 * @author by DELL
 * @date on 2020/06/11
 * @describe
 */
object RegularCons {
    /**
     * 正则：手机号（精确）
     *
     * 移动：134(0-8)、135、136、137、138、139、147、150、151、152、157、158、159、178、182、183、184、187、188
     *
     * 联通：130、131、132、145、155、156、175、176、185、186
     *
     * 电信：133、153、173、177、180、181、189
     *
     * 全球星：1349
     *
     * 虚拟运营商：170
     */
    @Deprecated("") //不太准确了
    val REGEX_MOBILE_EXACT = "^((13[0-9])|(14[5,7])|(15[0-3,5-9])|(17[0,3,5-8])|(18[0-9])|(199)|(166)|(147))\\d{8}$"

    /**
     * 正则：手机号 简单验证
     * 第一位必定为1，第二位必定为3或4或5或7或8，其他位置的可以为0-9
     */
    const val REGEX_MOBILE_SIMPLE = "[1][3456789]\\d{9}"

    /**
     * 正则：邮箱
     * 更严格
     */
    const val REGEX_EMAIL_EXACT = "^\\s*\\w+(?:\\.{0,1}[\\w-]+)*@[a-zA-Z0-9]+(?:[-.][a-zA-Z0-9]+)*\\.[a-zA-Z]+\\s*$"

    /**
     * 正则：邮箱
     */
    const val REGEX_EMAIL_SIMPLE = "^\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*$"

    /**
     * 正则：URL
     */
    const val REGEX_URL = "http(s)?://([\\w-]+\\.)+[\\w-]+(/[\\w-./?%&=]*)?"

    /**
     * 正则：汉字
     */
    const val REGEX_CHZ = "^[\\u4e00-\\u9fa5]+$"

    /**
     * 正则：IP地址
     */
    const val REGEX_IP = "((2[0-4]\\d|25[0-5]|[01]?\\d\\d?)\\.){3}(2[0-4]\\d|25[0-5]|[01]?\\d\\d?)"

    /**
     * 正则：密码
     * (长度在6~18之间，只能包含字母、数字和下划线)  ^[a-zA-Z0-9_]{6,18}$
     */
    const val REGEX_PASSWORD = "^[a-zA-Z0-9]{6}$"

    /**
     *
     * Regex of id card number which length is 15.
     *
     */
    const val REGEX_ID_CARD15 = "^[1-9]\\d{7}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}$"

    /**
     *
     * Regex of id card number which length is 18.
     *
     */
    const val REGEX_ID_CARD18 = "^[1-9]\\d{5}[1-9]\\d{3}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}([0-9Xx])$"
}