package com.softgarden.baselibrary.utils

import android.text.TextUtils
import java.util.*
import java.util.regex.Pattern

/**
 * @author by DELL
 * @date on 2020/06/11
 * @describe
 */
class RegularUtil private constructor() {
    companion object {
        /**
         * string是否匹配regex
         *
         * @param regex  正则表达式字符串
         * @param string 要匹配的字符串
         * @return `true`: 匹配<br></br>`false`: 不匹配
         */
        fun isMatch(regex: String?, string: String?): Boolean {
            return !TextUtils.isEmpty(string) && Pattern.matches(regex, string)
        }

        /**
         * 验证手机号（简单）
         *
         * @param string 待验证文本
         * @return `true`: 匹配<br></br>`false`: 不匹配
         */
        fun isMobileSimple(string: String?): Boolean {
            return isMatch(RegularCons.REGEX_MOBILE_SIMPLE, string)
        }

        /**
         * 验证手机号（精确）
         *
         * @param string 待验证文本
         * @return `true`: 匹配<br></br>`false`: 不匹配
         */
        fun isMobileExact(string: String?): Boolean {
            return isMatch(RegularCons.REGEX_MOBILE_EXACT, string)
        }

        /**
         * 验证邮箱（简单）
         *
         * @param string 待验证文本
         * @return `true`: 匹配<br></br>`false`: 不匹配
         */
        fun isEmailSimple(string: String?): Boolean {
            return isMatch(RegularCons.REGEX_EMAIL_SIMPLE, string)
        }

        /**
         * 验证邮箱(精确)
         *
         * @param string 待验证文本
         * @return `true`: 匹配<br></br>`false`: 不匹配
         */
        fun isEmail(string: String?): Boolean {
            return isMatch(RegularCons.REGEX_EMAIL_EXACT, string)
        }

        /**
         * 验证URL
         *
         * @param string 待验证文本
         * @return `true`: 匹配<br></br>`false`: 不匹配
         */
        fun isURL(string: String?): Boolean {
            return isMatch(RegularCons.REGEX_URL, string)
        }

        /**
         * 验证汉字
         *
         * @param string 待验证文本
         * @return `true`: 匹配<br></br>`false`: 不匹配
         */
        fun isChz(string: String?): Boolean {
            return isMatch(RegularCons.REGEX_CHZ, string)
        }

        /**
         * 验证IP地址
         *
         * @param string 待验证文本
         * @return `true`: 匹配<br></br>`false`: 不匹配
         */
        fun isIP(string: String?): Boolean {
            return isMatch(RegularCons.REGEX_IP, string)
        }

        /**
         * 验证密码
         *
         * @param string 待验证文本
         * @return `true`: 匹配<br></br>`false`: 不匹配
         */
        fun isPassword(string: String?): Boolean {
            return isMatch(RegularCons.REGEX_PASSWORD, string)
        }

        /**
         * Return whether input matches regex of id card number which length is 15.
         *
         * @param input The input.
         * @return `true`: yes<br></br>`false`: no
         */
        fun isIDCard15(input: String?): Boolean {
            return isMatch(RegularCons.REGEX_ID_CARD15, input)
        }

        /**
         * Return whether input matches regex of id card number which length is 18.
         *
         * @param input The input.
         * @return `true`: yes<br></br>`false`: no
         */
        fun isIDCard18(input: String?): Boolean {
            return isMatch(RegularCons.REGEX_ID_CARD18, input)
        }

        /**
         * Return whether input matches regex of exact id card number which length is 18.
         *
         * @param input The input.
         * @return `true`: yes<br></br>`false`: no
         */
        fun isIDCard18Exact(input: String): Boolean {
            if (isIDCard18(input)) {
                val factor = intArrayOf(7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2)
                val suffix = charArrayOf('1', '0', 'X', '9', '8', '7', '6', '5', '4', '3', '2')
                val CITY_MAP = HashMap<String, String?>()
                if (CITY_MAP.isEmpty()) {
                    CITY_MAP["11"] = "北京"
                    CITY_MAP["12"] = "天津"
                    CITY_MAP["13"] = "河北"
                    CITY_MAP["14"] = "山西"
                    CITY_MAP["15"] = "内蒙古"
                    CITY_MAP["21"] = "辽宁"
                    CITY_MAP["22"] = "吉林"
                    CITY_MAP["23"] = "黑龙江"
                    CITY_MAP["31"] = "上海"
                    CITY_MAP["32"] = "江苏"
                    CITY_MAP["33"] = "浙江"
                    CITY_MAP["34"] = "安徽"
                    CITY_MAP["35"] = "福建"
                    CITY_MAP["36"] = "江西"
                    CITY_MAP["37"] = "山东"
                    CITY_MAP["41"] = "河南"
                    CITY_MAP["42"] = "湖北"
                    CITY_MAP["43"] = "湖南"
                    CITY_MAP["44"] = "广东"
                    CITY_MAP["45"] = "广西"
                    CITY_MAP["46"] = "海南"
                    CITY_MAP["50"] = "重庆"
                    CITY_MAP["51"] = "四川"
                    CITY_MAP["52"] = "贵州"
                    CITY_MAP["53"] = "云南"
                    CITY_MAP["54"] = "西藏"
                    CITY_MAP["61"] = "陕西"
                    CITY_MAP["62"] = "甘肃"
                    CITY_MAP["63"] = "青海"
                    CITY_MAP["64"] = "宁夏"
                    CITY_MAP["65"] = "新疆"
                    CITY_MAP["71"] = "台湾"
                    CITY_MAP["81"] = "香港"
                    CITY_MAP["82"] = "澳门"
                    CITY_MAP["91"] = "国外"
                }
                if (CITY_MAP[input.subSequence(0, 2).toString()] != null) {
                    var weightSum = 0
                    for (i in 0..16) {
                        weightSum += (input[i] - '0') * factor[i]
                    }
                    val idCardMod = weightSum % 11
                    val idCardLast = input[17]
                    return idCardLast == suffix[idCardMod]
                }
            }
            return false
        }
    }

    /**
     * If u want more please visit http://toutiao.com/i6231678548520731137/
     */
    init {
        throw UnsupportedOperationException("u can't fuck me...")
    }
}