package com.softgarden.baselibrary.utils

import android.Manifest.permission



import android.app.Service
import android.content.Context
import android.content.DialogInterface
import android.location.LocationManager
import android.os.Handler
import androidx.appcompat.app.AlertDialog
import androidx.appcompat.app.AppCompatActivity

import com.softgarden.baselibrary.R
import com.tbruyelle.rxpermissions3.RxPermissions
import io.reactivex.rxjava3.core.Observable


/**
 * @author by DELL
 * @date on 2020/06/11
 * @describe
 */
object RxPermissionsUtil {


    /*** 打电话  */
    val PHONE = arrayOf(permission.CALL_PHONE)

    /*** 蓝牙/WIFI 需要粗略定位  */
    val LOCATION = arrayOf( /*permission.TOOTH,*/permission.ACCESS_COARSE_LOCATION)

    /*** 文件存储 电话状态 */
    val STORAGE = arrayOf(permission.WRITE_EXTERNAL_STORAGE, permission.READ_EXTERNAL_STORAGE)

    /**
     * 电话状态
     */
    val PHONE_STATE = arrayOf(permission.READ_PHONE_STATE)

    /*** 摄像头  */
    val CAMERA = arrayOf(permission.CAMERA)

    /*** 录音  */
    val AUDIO = arrayOf(permission.RECORD_AUDIO)

    /*** 摄像头+文件存储  */
    val CAMERA_STORAGE = arrayOf(permission.CAMERA, permission.WRITE_EXTERNAL_STORAGE, permission.READ_EXTERNAL_STORAGE)

    /**
     * 检测 GPS/位置服务是否开启
     *
     * @param context
     * @return
     */
    fun checkGPSEnable(context: Context): Boolean {
        val lm = context.getSystemService(Service.LOCATION_SERVICE) as LocationManager
        return lm.isProviderEnabled(LocationManager.GPS_PROVIDER)
    }

    fun request(activity: AppCompatActivity?, vararg permissions: String?): Observable<Boolean> {
        return RxPermissions(activity!!).request(*permissions)
    }

    fun shouldShowRequestPermissionRationale(activity: AppCompatActivity?, vararg permissions: String?): Observable<Boolean> {
        return RxPermissions(activity!!).shouldShowRequestPermissionRationale(activity, *permissions)
    }

    fun check(activity: AppCompatActivity?, permissions: Array<String>,
              title: String?,  /*final String cancelText, String ensureText, */
              listener: OnPermissionRequestListener?) {
        activity?.let {
            RxPermissions(it).requestEachCombined(*permissions)
                    .subscribe { permission ->
                        when {
                            permission.granted -> { //已获取权限
                                //要延时 ，否则显示弹窗会报错
                                mHandler.postDelayed({ listener?.onSucceed() }, 100)
                            }
                            permission.shouldShowRequestPermissionRationale -> {
                                //是否需要向用户解释为何申请权限
                                check(activity, permissions, title, listener)
                            }
                            else -> { //被拒绝，弹窗提示
                                listener?.onFailed()
                            }
                        }
                    }
        }

    }

    /**
     * 提示缺少什么权限的对话框
     */
    fun showPermissionDialog(context: Context?, title: String?, message: String?,
                             onClickListener: DialogInterface.OnClickListener?) {

        //  new PromptDialog().setTitle(title).setContent(message).setNegativeButton().setPositiveButton().setOnButtonClickListener().show(context);
        AlertDialog.Builder(context!!)
                .setTitle(title)
                .setMessage(message)
                .setNegativeButton(R.string.base_cancel) { dialog, which -> }
                .setPositiveButton(R.string.base_ok, onClickListener).show()
    }

    /**
     * 提示缺少必要权限对话框
     */
    fun showLackPermissionDialog(context: Context) {
        AlertDialog.Builder(context)
                .setTitle(R.string.base_prompt_message)
                .setMessage(R.string.base_permission_lack)
                .setNegativeButton(R.string.base_cancel) { dialog, which -> }
                .setPositiveButton(R.string.base_ok) { dialog, which -> AppUtil.Companion.openAppSetting(context) }.show()
    }

    private val mHandler = Handler()

    interface OnPermissionRequestListener {
        fun onSucceed()
        fun onFailed()
    }
}