package com.softgarden.baselibrary.utils

import android.content.Context
import android.content.SharedPreferences
import android.text.TextUtils
import android.util.Base64
import com.softgarden.baselibrary.BaseApplication
import java.io.*

/**
 * @author by DELL
 * @date on 2020/06/11
 * @describe
 */
class SPUtil private constructor() {
    companion object {
        /**
         * 此文件名  和rx-preferences 保持一致
         * 详情见 https://github.com/f2prateek/rx-preferences
         *
         * @return
         */
        val sP: SharedPreferences
            get() {
                val context: Context = BaseApplication.Companion.instance!!.applicationContext
                return context.getSharedPreferences(context.packageName + "_preferences",
                        Context.MODE_PRIVATE)
            }

        /**
         * 保存序列化对象到本地
         *
         * @param key
         * @param object
         */
        fun putSerializableObject(key: String?, `object`: Any?) {
            if (`object` == null) {
                put(key, null)
                return
            }
            if (`object` !is Serializable) {
                throw RuntimeException("SharedPreferences save bean need implements Serializable")
            }
            try {
                //先将序列化结果写到byte缓存中，其实就分配一个内存空间
                val bos = ByteArrayOutputStream()
                val os = ObjectOutputStream(bos)
                os.writeObject(`object`) //将对象序列化写入byte缓存
                //将序列化的数据用Base64加密
                val base64Str = Base64.encodeToString(bos.toByteArray(), Base64.NO_PADDING)
                //保存该16进制数组
                put(key, base64Str)
            } catch (e: IOException) {
                e.printStackTrace()
            }
        }

        /**
         * 从本地反序列化获取对象
         *
         * @param key
         * @return
         */
        fun <T : Serializable?> getSerializableObject(key: String?): T? {
            if (sP.contains(key)) {
                val string = get(key, "") as String
                if (TextUtils.isEmpty(string)) {
                    return null
                } else {
                    try {
                        //Base64解密转为数组，准备反序列化
                        val stringToBytes = Base64.decode(string, Base64.NO_PADDING)
                        val bis = ByteArrayInputStream(stringToBytes)
                        val `is` = ObjectInputStream(bis)
                        //返回反序列化得到的对象
                        val readObject = `is`.readObject()
                        return readObject as T
                    } catch (e: IOException) {
                        e.printStackTrace()
                    } catch (e: ClassNotFoundException) {
                        e.printStackTrace()
                    }
                }
            }
            return null
        }

        /**
         * 保存数据的方法，我们需要拿到保存数据的具体类型，然后根据类型调用不同的保存方法
         *
         * @param key
         * @param object
         */
        fun put(key: String?, `object`: Any?) {
            val editor = sP.edit()
            if (`object` == null) {
                editor.putString(key, null)
            } else if (`object` is String) {
                editor.putString(key, `object` as String?)
            } else if (`object` is Int) {
                editor.putInt(key, (`object` as Int?)!!)
            } else if (`object` is Boolean) {
                editor.putBoolean(key, (`object` as Boolean?)!!)
            } else if (`object` is Float) {
                editor.putFloat(key, (`object` as Float?)!!)
            } else if (`object` is Long) {
                editor.putLong(key, (`object` as Long?)!!)
            } else if (`object` != null) {
                editor.putString(key, `object`.toString())
            }
            editor.commit()
        }

        /**
         * 得到保存数据的方法，我们根据默认值得到保存的数据的具体类型，然后调用相对于的方法获取值
         *
         * @param key
         * @param defaultObject
         * @return
         */
        operator fun get(key: String?, defaultObject: Any): Any {
            val sp = sP
            return when (defaultObject) {
                is String -> {
                    sp.getString(key, defaultObject) as Any
                }
                is Int -> {
                    sp.getInt(key, defaultObject)
                }
                is Boolean -> {
                    sp.getBoolean(key, defaultObject)
                }
                is Float -> {
                    sp.getFloat(key, defaultObject)
                }
                is Long -> {
                    sp.getLong(key, defaultObject)
                }
                else -> {
                    throw RuntimeException("The default value defaultObject not be null,you must define Class type")
                }
            }
        }

        /**
         * 移除某个key值已经对应的值
         *
         * @param key
         */
        fun remove(key: String?) {
            val sp = sP
            val editor = sp.edit()
            editor.remove(key)
            editor.commit()
        }

        /**
         * 清除所有数据
         */
        fun clear() {
            val sp = sP
            val editor = sp.edit()
            editor.clear()
            editor.commit()
        }

        /**
         * 查询某个key是否已经存在
         *
         * @param key
         * @return
         */
        operator fun contains(key: String?): Boolean {
            val sp = sP
            return sp.contains(key)
        }

        /**
         * 返回所有的键值对
         *
         * @return
         */
        val all: Map<String, *>
            get() {
                val sp = sP
                return sp.all
            }
    }

    init {
        throw UnsupportedOperationException("u can't fuck me...")
    }
}