package com.softgarden.baselibrary.utils

import kotlin.experimental.and

/**
 * @author by DELL
 * @date on 2020/06/11
 * @describe
 */
object StringUtil {
    /**
     * 将字符串列表 用逗号隔开 组合成新的字符串
     *
     * @param list
     * @return
     */
    fun insertDot(list: List<String>): String {
        return insert(list, ",")
    }

    /**
     * 将字符串列表 用逗号或别的符号隔开 组合成新的字符串
     *
     * @param list 字符串列表
     * @param reg  要隔开的符号
     * @return
     */
    fun insert(list: List<String>, reg: String): String {
        if (EmptyUtil.Companion.isEmpty(list)) return ""
        val sb = StringBuilder()
        for (i in list.indices) {
            sb.append(reg + list[i])
        }
        return subPrefix(sb.toString(), reg)
    }

    /**
     * 截取前缀 第一个 ，逗号
     *
     * @return
     */
    @JvmOverloads
    fun subPrefix(str: String, reg: String = ","): String {
        var str = str
        if (EmptyUtil.Companion.isNotEmpty(str) && str.startsWith(reg)) {
            str = str.substring(reg.length)
        }
        return str
    }

    /**
     * 截取后缀
     *
     * @param str
     * @return
     */
    @JvmOverloads
    fun subSuffix(str: String, reg: String = ","): String {
        var str = str
        if (EmptyUtil.Companion.isNotEmpty(str) && str.endsWith(reg)) {
            str = str.substring(0, str.length - reg.length)
        }
        return str
    }

    //将16进制的字符串转换成byte数组，每2个16进制数字转成一个byte
    fun hex2Bytes(hex: String): ByteArray {
        var hex = hex
        hex = hex.replace("[^0-9,a-f,A-F]".toRegex(), "")
        val bytes = ByteArray(hex.length / 2)
        for (i in bytes.indices) {
            bytes[i] = hex.substring(i * 2, i * 2 + 2).toInt(
                    16).toByte()
        }
        return bytes
    }

    // 将字节数组转换成16进制字符串
    fun byte2Hexstr(bytes: ByteArray): String {
        val buf = StringBuilder(bytes.size * 2)
        for (i in bytes.indices) {
            //这里java可以位运算bytes，但是kotlin只能int或者long类型
            var tmp: Int = bytes[i].toInt().shr(4) and (0x0F)
            buf.append(getHexChar(tmp))
            tmp = bytes[i].toInt() and (0x0F)
            buf.append(getHexChar(tmp))
        }
        return buf.toString()
    }

    private fun getHexChar(value: Int): Char {
        return if (value >= 0 && value < 10) {
            ('0'.toInt() + value).toChar()
        } else {
            ('A'.toInt() + (value - 10)).toChar()
        }
    }

    fun toBinaryString(num: Int): String {
        val value = Integer.toBinaryString(num)
        if (value.length < 8) {
            val sb = StringBuilder()
            for (i in 0 until 8 - value.length) {
                sb.append("0")
            }
            sb.append(value)
            return sb.toString()
        }
        return value
    }
}