package com.softgarden.baselibrary.utils

import android.content.Context
import android.os.Build
import android.view.Gravity
import android.view.LayoutInflater
import android.view.View
import android.widget.TextView
import android.widget.Toast
import com.softgarden.baselibrary.BaseApplication
import com.softgarden.baselibrary.R

class ToastUtil private constructor() {
    companion object {
        private var mToast: Toast? = null
        private var mTvMessage: TextView? = null

        /**
         * miui部分版本会自带包名 用此方法解决该Bug
         */
        private fun createToast(context: Context?, message: CharSequence?, duration: Int) {
            if (mToast == null) {
                mToast = Toast(context)
                val inflate = context?.getSystemService(Context.LAYOUT_INFLATER_SERVICE) as LayoutInflater
                val v = inflate.inflate(R.layout.transient_notification_toast, null)
                mTvMessage = v.findViewById<View>(R.id.message) as TextView
                mTvMessage!!.text = message
                mToast!!.view = v
                mToast!!.duration = duration
            } else {
                mTvMessage?.text = message

            }

        }

        fun show(message: CharSequence?, duration: Int) {
            if (message?.contains("parameter savedInstanceState") == true) {
                return
            }
            //缓存一个Toast 这种方式体验感觉最好，Toast消失的计时会从最后一次show之后才开始计算，还可以通过setText设置不同的内容

//            if (mToast == null) {
//                mToast = Toast.makeText(BaseApplication.instance,
//                        message, duration)
//            } else {
//                mToast?.setText(message);
//            }

            val context: Context? = BaseApplication.instance?.applicationContext
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) { //8.0对Toast做了改动
                createToast(context, message, duration)
            } else {
                when {
                    mToast == null -> {
                        createToast(context, message, duration)
                    }
                    mTvMessage != null -> {
                        mTvMessage?.text = message
                    }
                    else -> {
                        mToast = null
                        show(message, duration)
                    }
                }
            }
            mToast!!.setGravity(Gravity.CENTER, 0, 0)
            mToast!!.show()
        }

        /**
         * short Toast
         *
         * @param msg
         */
        fun s(msg: String?) {
            show(msg, Toast.LENGTH_SHORT)
        }
        /**
         * short Toast
         * 多语言适配时 getString跟context.getResources() 有关，必须使用当前Context
         *
         * @param msgId
         */
        //    public static void s(@StringRes int msgId) {
        //        s(BaseApplication.getInstance().getApplicationContext().getResources().getString(msgId));
        //    }
        /**
         * long Toast
         *
         * @param msg
         */
        fun l(msg: String?) {
            show(msg, Toast.LENGTH_LONG)
        }
        /**
         * long Toast
         * 多语言适配时 getString跟context.getResources() 有关，必须使用当前Context
         *
         * @param msgId
         */
        //    public static void l(@StringRes int msgId) {
        //        l(BaseApplication.getInstance().getApplicationContext().getResources().getString(msgId));
        //    }
    }

    init {
        throw UnsupportedOperationException("u can't fuck me...")
    }
}