package com.softgarden.baselibrary.utils

import android.text.Editable
import android.text.method.HideReturnsTransformationMethod
import android.text.method.PasswordTransformationMethod
import android.widget.EditText

/**
 * @author by DELL
 * @date on 2020/06/11
 * @describe
 */
object ViewUtil {
    fun showPassword(editText: EditText, show: Boolean) {
        if (show) {
            editText.transformationMethod = HideReturnsTransformationMethod.getInstance()
        } else {
            editText.transformationMethod = PasswordTransformationMethod.getInstance()
        }
    }

    /**
     * 限制小数点后2位
     * 可在 afterTextChanged（） 中使用
     *
     * @param editable
     */
    fun limitPointNumber(editable: Editable) {
        val limitPoint = 2 //限制小数点后2位
        val temp = editable.toString()
        val posDot = temp.indexOf(".")
        if (posDot < 0) {
            return
        }
        //补零
        if (posDot == 0) {
            editable.insert(0, "0")
            return
        }

        //删除多余的小数点
        if (temp.length - posDot - 1 > limitPoint) {
            editable.delete(posDot + limitPoint + 1, posDot + limitPoint + 2)
        }
    }
}