package com.softgarden.baselibrary.widget

import android.content.Context

import android.util.AttributeSet
import android.util.Log
import android.view.MotionEvent
import android.view.View
import androidx.viewpager.widget.ViewPager
import com.softgarden.baselibrary.utils.L
import com.softgarden.baselibrary.widget.AutoFitViewPager

/**
 * @author by DELL
 * @date on 2020/06/11
 * @describe 自动适应子View高度的Viewpager
 */
class AutoFitViewPager @JvmOverloads constructor(context: Context?, attrs: AttributeSet? = null) : ViewPager(context!!, attrs) {
    var isNoScroll = true //true 代表不能滑动 //false 代表能滑动
    override fun onMeasure(widthMeasureSpec: Int, heightMeasureSpec: Int) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec)
        L.d(TAG, "onMeasure")
        // find the current child view
        val view = getChildAt(currentItem)
        view?.measure(widthMeasureSpec, heightMeasureSpec)
        setMeasuredDimension(measuredWidth, measureHeight(heightMeasureSpec, view))
    }

    private fun measureHeight(measureSpec: Int, view: View?): Int {
        var result = 0
        val specMode = MeasureSpec.getMode(measureSpec)
        val specSize = MeasureSpec.getSize(measureSpec)
        if (specMode == MeasureSpec.EXACTLY) {
            result = specSize
        } else {
            // set the height from the base view if available
            if (view != null) {
                result = view.measuredHeight
            }
            if (specMode == MeasureSpec.AT_MOST) {
                result = Math.min(result, specSize)
            }
        }
        return result
    }

    override fun onTouchEvent(arg0: MotionEvent): Boolean {
        /* return false;//super.onTouchEvent(arg0); */
        return if (isNoScroll) false else super.onTouchEvent(arg0)
    }

    override fun onInterceptTouchEvent(arg0: MotionEvent): Boolean {
        return if (isNoScroll) false else super.onInterceptTouchEvent(arg0)
    }

    override fun setCurrentItem(item: Int) {
        super.setCurrentItem(item, false) //表示切换的时候，不需要切换时间。
    }

    companion object {
        val TAG = AutoFitViewPager::class.java.simpleName
    }

    init {
        addOnPageChangeListener(object : OnPageChangeListener {
            override fun onPageScrolled(position: Int, positionOffset: Float, positionOffsetPixels: Int) {}
            override fun onPageSelected(position: Int) {
                requestLayout()
            }

            override fun onPageScrollStateChanged(state: Int) {}
        })
    }
}