package com.softgarden.baselibrary.widget

import android.R
import android.content.Context
import android.graphics.Canvas
import android.util.AttributeSet
import androidx.appcompat.widget.AppCompatTextView

/**
 * @author by DELL
 * @date on 2020/06/11
 * @describe
 */
class AutoZoomTextView @JvmOverloads constructor(context: Context?, attrs: AttributeSet? = null, defStyleAttr: Int = 0) : AppCompatTextView(context, attrs, defStyleAttr) {
    private var maxWidth = 0f
    private var defaultTextSize = 0f
    override fun onMeasure(widthMeasureSpec: Int, heightMeasureSpec: Int) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec)
        val widthMode = MeasureSpec.getMode(widthMeasureSpec)
        if (widthMode == MeasureSpec.AT_MOST) {
            maxWidth = R.attr.maxWidth.toFloat()
            maxWidth = MeasureSpec.getSize(widthMeasureSpec).toFloat()
        }
    }

    override fun onDraw(canvas: Canvas) {
        val paint = paint
        if (defaultTextSize == 0.0f) {
            defaultTextSize = textSize
        }
        var textSize = defaultTextSize
        paint.textSize = textSize
        /***support zoom */
        if (maxWidth == 0f) maxWidth = width.toFloat()
        val textViewWidth = maxWidth - paddingLeft - paddingRight.toFloat() //不包含左右padding的空间宽度
        var textViewWidth1 = textViewWidth - paint.fontSpacing * 2 //不包含左右字体空间
        val text = text.toString()
        var textWidth = paint.measureText(text)
        while (textWidth > textViewWidth1) {
            textSize--
            paint.textSize = textSize
            textWidth = paint.measureText(text)
            textViewWidth1 = textViewWidth - paint.fontSpacing * 2
        }
        super.onDraw(canvas)
    }


}