package com.softgarden.baselibrary.widget

import android.content.Context

import android.util.AttributeSet
import android.view.MotionEvent
import androidx.appcompat.widget.AppCompatImageView

/**
 * @author by DELL
 * @date on 2020/06/11
 * @describe
 */
class ClickImageView : AppCompatImageView {
    constructor(context: Context?) : super(context) {
        isClickable = true
    }

    constructor(context: Context?, attrs: AttributeSet?) : super(context, attrs) {
        isClickable = true
    }

    constructor(context: Context?, attrs: AttributeSet?, defStyleAttr: Int) : super(context, attrs, defStyleAttr) {
        isClickable = true
    }

    override fun onTouchEvent(event: MotionEvent): Boolean {
        when (event.action) {
            MotionEvent.ACTION_DOWN -> this.setColorFilter(-0x67000000)
            MotionEvent.ACTION_UP, MotionEvent.ACTION_CANCEL -> this.colorFilter = null
        }
        return super.onTouchEvent(event)
    }
}