package com.softgarden.baselibrary.widget

import android.graphics.Canvas
import android.graphics.Paint
import android.graphics.Rect

import android.view.View
import androidx.annotation.ColorInt
import androidx.recyclerview.widget.OrientationHelper
import androidx.recyclerview.widget.RecyclerView

/**
 * @author by DELL
 * @date on 2020/06/11
 * @describe
 */
class ColorDividerDecoration @JvmOverloads constructor(mOrientation: Int, @ColorInt mDividerColor: Int, mDividerHeight: Int, mShowDividers: Int = MIDDLE) : RecyclerView.ItemDecoration() {
    // private Context mContext;
    /**
     * 画笔
     */
    private var mPaint: Paint? = null

    /**
     * 方向 默认垂直方向
     */
    private var mOrientation = VERTICAL

    /**
     * 分割线颜色
     */
    private val mDividerColor: Int

    /**
     * 分割线高度
     */
    private val mDividerHeight: Int

    /**
     * 分割线显示模式 头部和中间  仅显示中间  中间和底部
     */
    private val mShowDividers: Int

    //    private int mPadding;//
    //    private int mLeftPadding;//
    //    private int mRightPadding;//
    constructor(@ColorInt mDividerColor: Int) : this(VERTICAL, mDividerColor, 1, BEGINNING_MIDDLE)
    constructor(@ColorInt mDividerColor: Int, mDividerHeight: Int) : this(VERTICAL, mDividerColor, mDividerHeight, BEGINNING_MIDDLE)

    private fun initPaint() {
        mPaint = Paint()
        mPaint!!.color = mDividerColor
        mPaint!!.isAntiAlias = true
    }

    override fun onDraw(c: Canvas, parent: RecyclerView, state: RecyclerView.State) {
        if (mOrientation == VERTICAL) {
            drawVertical(c, parent)
        } else {
            drawHorizontal(c, parent)
        }
    }

    /**
     * @param c
     * @param parent
     */
    private fun drawHorizontal(c: Canvas, parent: RecyclerView) {
        val top = parent.paddingTop
        val bottom = parent.height - parent.paddingBottom
        var childCount = parent.childCount
        childCount = if (mShowDividers == MIDDLE) childCount - 1 else childCount //不画最后一个
        for (i in 1 until childCount) {
            val child = parent.getChildAt(i)
            val params = child.layoutParams as RecyclerView.LayoutParams
            val left = child.right + params.rightMargin
            val right = left + mDividerHeight
            mPaint?.let {
                c.drawRect(left.toFloat(), top.toFloat(), right.toFloat(), bottom.toFloat(), it)
            }

        }
    }

    /**
     * @param c
     * @param parent
     */
    private fun drawVertical(c: Canvas, parent: RecyclerView) {
        val left = parent.paddingLeft
        val right = parent.width - parent.paddingRight
        var childCount = parent.childCount
        childCount = if (mShowDividers == MIDDLE) childCount - 1 else childCount //不画最后一个
        for (i in 0 until childCount) {
            val child = parent.getChildAt(i)
            val params = child.layoutParams as RecyclerView.LayoutParams
            val top = child.bottom + params.bottomMargin
            val bottom = top + mDividerHeight
            mPaint?.let {
                c.drawRect(left.toFloat(), top.toFloat(), right.toFloat(), bottom.toFloat(), it)
            }

        }
    }

    override fun getItemOffsets(outRect: Rect, view: View, parent: RecyclerView, state: RecyclerView.State) {
        if (mOrientation == VERTICAL) {
            if (mShowDividers == BEGINNING_MIDDLE) {
                outRect[0, mDividerHeight, 0] = 0
            } else {
                outRect[0, 0, 0] = mDividerHeight
            }
        } else {
            if (mShowDividers == BEGINNING_MIDDLE) {
                outRect[mDividerHeight, 0, 0] = 0
            } else {
                outRect[0, 0, mDividerHeight] = 0
            }
        }
    }

    fun setOrientation(orientation: Int) {
        mOrientation = orientation
    }

    companion object {
        const val HORIZONTAL = OrientationHelper.HORIZONTAL
        const val VERTICAL = OrientationHelper.VERTICAL
        const val BEGINNING_MIDDLE = 0
        const val MIDDLE = 1
        const val MIDDLE_END = 2
    }

    init {
        this.mOrientation = mOrientation
        this.mDividerColor = mDividerColor
        this.mDividerHeight = mDividerHeight
        this.mShowDividers = mShowDividers
        initPaint()
    }
}