/*
 * Copyright 2017 Zhihu Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.softgarden.baselibrary.widget

import android.graphics.Rect

import androidx.recyclerview.widget.RecyclerView
import androidx.recyclerview.widget.RecyclerView.ItemDecoration
import android.view.View
import androidx.recyclerview.widget.GridLayoutManager

/**
 * @author by DELL
 * @date on 2020/06/11
 * @describe 只有 一个 header  的时候
 */
class GridHeaderDivider(private val mSpanCount: Int, private val mSpacing: Int, private val mIncludeEdge: Boolean) : ItemDecoration() {
    override fun getItemOffsets(outRect: Rect, view: View, parent: RecyclerView,
                                state: RecyclerView.State) {
        val position = parent.getChildAdapterPosition(view) // item position
        val manager = parent.layoutManager as GridLayoutManager
        val sizeLookup = manager.spanSizeLookup
        val count = sizeLookup.getSpanSize(position) //一行mSpanCount个 该item 占该行 几个
        val column: Int
        column = if (count != 1) { //添加了header
            0
        } else {
            (position - 1) % mSpanCount // item column
        }
        if (mIncludeEdge) {
            if (count == 1) {
                // spacing - column * ((1f / spanCount) * spacing)
                outRect.left = (mSpacing - column * mSpacing * 1f / mSpanCount).toInt()
                // (column + 1) * ((1f / spanCount) * spacing)
                outRect.right = ((column + 1) * mSpacing * 1f / mSpanCount).toInt()
            }
            if (position < 1) { // top edge
                outRect.top = mSpacing
            }
            outRect.bottom = mSpacing // item bottom
        } else {
            if (count == 1) {

                // column * ((1f / spanCount) * spacing)
                // outRect.left = column * mSpacing / mSpanCount;
                outRect.left = (column * mSpacing * 1f / mSpanCount).toInt()

                // spacing - (column + 1) * ((1f / spanCount) * spacing)
                // outRect.right = mSpacing - (column + 1) * mSpacing / mSpanCount;
                outRect.right = (mSpacing - (column + 1) * 1f * mSpacing / mSpanCount).toInt()
            }
            if (position >= 1) { //添加了header
                outRect.top = mSpacing // item top
            }
        }
    }

}