package com.softgarden.baselibrary.widget

import android.content.Context
import android.net.Uri
import android.util.AttributeSet
import android.util.SparseArray
import android.util.TypedValue
import android.view.Gravity
import android.view.View
import android.widget.FrameLayout
import android.widget.ImageView
import android.widget.TextView
import com.bumptech.glide.Glide
import com.softgarden.baselibrary.R
import java.util.*

/**
 * @author by DELL
 * @date on 2020/06/11
 * @describe 九宫格图片
 */
class NinePicturesLayout(context: Context, attrs: AttributeSet?) : FrameLayout(context, attrs), View.OnClickListener {
    private val lpChildImage = LayoutParams(LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT)
    private val mSingleMaxSize: Int
    private val mSpace: Int
    private val iPictureList: MutableList<ImageView> = ArrayList()
    private val mVisiblePictureList = SparseArray<ImageView>()
    private val tOverflowCount: TextView
    private var mCallback: Callback? = null
    private var isInit = false
    private var mDataList: List<Uri>? = null
    private var mThumbDataList: List<Uri>? = null
    operator fun set(urlThumbList: List<Uri>?, urlList: List<Uri>?) {
        mThumbDataList = urlThumbList
        mDataList = urlList
        if (isInit) {
            notifyDataChanged()
        }
    }

    private fun notifyDataChanged() {
        val thumbList = mThumbDataList
        val urlListSize = if (thumbList != null) mThumbDataList!!.size else 0
        if (thumbList == null || thumbList.size < 1) {
            visibility = View.GONE
            return
        } else {
            visibility = View.VISIBLE
        }
        require(thumbList.size <= mDataList!!.size) { "dataList.size(" + mDataList!!.size + ") > thumbDataList.size(" + thumbList.size + ")" }
        var column = 3
        if (urlListSize == 1) {
            column = 1
        } else if (urlListSize == 4) {
            column = 2
        }
        var row = 0
        if (urlListSize > 6) {
            row = 3
        } else if (urlListSize > 3) {
            row = 2
        } else if (urlListSize > 0) {
            row = 1
        }
        val imageSize = if (urlListSize == 1) mSingleMaxSize else ((width * 1f - mSpace * (column - 1)) / column).toInt()
        lpChildImage.width = imageSize
        lpChildImage.height = lpChildImage.width
        tOverflowCount.visibility = if (urlListSize > MAX_DISPLAY_COUNT) View.VISIBLE else View.GONE
        tOverflowCount.text = "+ " + (urlListSize - MAX_DISPLAY_COUNT)
        tOverflowCount.layoutParams = lpChildImage
        mVisiblePictureList.clear()
        for (i in iPictureList.indices) {
            val iPicture = iPictureList[i]
            if (i < urlListSize) {
                iPicture.visibility = View.VISIBLE
                mVisiblePictureList.put(i, iPicture)
                iPicture.layoutParams = lpChildImage
                iPicture.setBackgroundResource(R.drawable.loading)
                loadPictures(iPicture, thumbList[i])
                iPicture.translationX = i % column * (imageSize + mSpace).toFloat()
                iPicture.translationY = i / column * (imageSize + mSpace).toFloat()
            } else {
                iPicture.visibility = View.GONE
            }
            if (i == MAX_DISPLAY_COUNT - 1) {
                tOverflowCount.translationX = i % column * (imageSize + mSpace).toFloat()
                tOverflowCount.translationY = i / column * (imageSize + mSpace).toFloat()
            }
        }
        layoutParams.height = imageSize * row + mSpace * (row - 1)
    }

    /**
     * 加载图片 ，需要重写
     * @param iPicture
     * @param uri
     */
    private fun loadPictures(iPicture: ImageView, uri: Uri) {
        Glide.with(context).load(uri).into(iPicture)
    }

    override fun onClick(v: View) {
        if (mCallback != null) {
            mCallback!!.onThumbPictureClick(v as ImageView, mVisiblePictureList, mDataList)
        }
    }

    interface Callback {
        fun onThumbPictureClick(i: ImageView?, imageGroupList: SparseArray<ImageView>?, urlList: List<Uri>?)
    }

    fun setCallback(callback: Callback?) {
        mCallback = callback
    }

    override fun onSizeChanged(w: Int, h: Int, oldw: Int, oldh: Int) {
        super.onSizeChanged(w, h, oldw, oldh)
        isInit = true
        notifyDataChanged()
    }

    companion object {
        const val MAX_DISPLAY_COUNT = 9
    }

    init {
        val mDisplayMetrics = context.resources.displayMetrics
        mSingleMaxSize = (TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 216f, mDisplayMetrics) + 0.5f).toInt()
        mSpace = (TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 2f, mDisplayMetrics) + 0.5f).toInt()
        for (i in 0 until MAX_DISPLAY_COUNT) {
            val squareImageView: ImageView = SquareImageView(context)
            squareImageView.scaleType = ImageView.ScaleType.CENTER_CROP
            squareImageView.visibility = View.GONE
            squareImageView.setOnClickListener(this)
            addView(squareImageView)
            iPictureList.add(squareImageView)
        }
        tOverflowCount = TextView(context)
        tOverflowCount.setTextColor(-0x1)
        tOverflowCount.textSize = 24f
        tOverflowCount.gravity = Gravity.CENTER
        tOverflowCount.setBackgroundColor(0x66000000)
        tOverflowCount.visibility = View.GONE
        addView(tOverflowCount)
    }
}