package com.softgarden.baselibrary.widget

import android.content.Context
import android.util.AttributeSet
import android.widget.LinearLayout

/**
 * @author by DELL
 * @date on 2020/06/11
 * @describe 正方形布局
 */
class SquareLinearLayout : LinearLayout {
    constructor(context: Context?, attrs: AttributeSet?, defStyle: Int) : super(context, attrs, defStyle)
    constructor(context: Context?, attrs: AttributeSet?) : super(context, attrs)
    constructor(context: Context?) : super(context)

    override fun onMeasure(widthMeasureSpec: Int, heightMeasureSpec: Int) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec)
        var size = 0
        val width = measuredWidth
        val height = measuredHeight
        size = if (width > height) {
            height
        } else {
            width
        }
        setMeasuredDimension(size, size)
    }
}