package com.live.common.domain.request;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;

@Data
public class UserApplyAnchorRequest {

    @NotBlank(message = "真实姓名")
    private String name;

    @NotBlank(message = "请输入身份证号码")
    @Size(max = 18, min = 15, message = "请输入15 - 18位身份证号码")
    private String idCard;

    @NotBlank(message = "请上传身份证正面照")
    private String cardPhotoPositive;

    @NotBlank(message = "请上传身份证反面照")
    private String cardPhotoReverse;

}
