package com.live.common.utils;

import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;

/**
 * url工具类
 */
public class UrlParamUtils {
	private static final String EMPTY = "";
	private static final String EQUALS = "=";
	private static final String DEFAULT_SEPARATOR = "&";
	
	public static String toUrlParam(Map<String, String> params) {
		return toUrlParam(params, DEFAULT_SEPARATOR, true);
	}
	
	public static String toUrlParam(Map<String, String> params, String separator) {
		return toUrlParam(params, separator, true);
	}
	
	public static String toUrlParam(Map<String, String> params, String separator, boolean ignoreEmpty) {
		if (params == null || params.isEmpty()) {
			return EMPTY;
		}
		
		StringBuffer url = new StringBuffer();
		
		Iterator<Entry<String, String>> it = params.entrySet().iterator();
		while(it.hasNext()) {
			Entry<String, String> entry = it.next();
			String value = entry.getValue();
			boolean valueIsEmpty = isEmpty(value);
			if (ignoreEmpty && valueIsEmpty) { // 主动忽略空值并且值为空
				continue;
			}
			
			url.append(entry.getKey()).append(EQUALS) .append(value);
			if (it.hasNext()) {
				url.append(separator);
			}
		}
		
		return url.toString();
	}

	public static String toUrlParamWithoutEmpty(Map<String, String> params, String separator) {
		if (params == null || params.isEmpty()) {
			return EMPTY;
		}

		StringBuffer url = new StringBuffer();

		Iterator<Entry<String, String>> it = params.entrySet().iterator();
		while(it.hasNext()) {
			Entry<String, String> entry = it.next();
			String value = entry.getValue();
			if (StringUtils.isEmpty(value)) { // 主动忽略空值并且值为空
				continue;
			}

			url.append(entry.getKey()).append(EQUALS) .append(value);
			if (it.hasNext()) {
				url.append(separator);
			}
		}

		String urlStr = url.toString();
		if (urlStr.endsWith(separator)) {
			urlStr = urlStr.substring(0, urlStr.length() - separator.length());
		}

		return urlStr;
	}
	
	private static boolean isEmpty(String value) {
		return value == null || EMPTY.equals(value);
	}
	
	public static Map<String, String> fromUrlParam(String url) {
		Map<String, String> paramsMap = new HashMap<>();

		String[] params = url.split(DEFAULT_SEPARATOR);
		for (String param : params) {
			String[] values = param.split(EQUALS);

			if (values == null) {
				continue;
			}

			String key = values.length > 0 ? values[0] : null;
			String value = values.length > 1 ? values[1] : null;
			if (key == null) {
				continue;
			}

			paramsMap.put(key, value);
		}

		return paramsMap;
	}
}
