package com.live.common.enums;

import lombok.ToString;


/**
 * 系统级别错误码10001-11000
 *
 * 只放公共的系统错误码
 */
@ToString
public  enum ErrorCode implements CheckCodeMessage{
    SERVER_ERROR("10000","系统异常"),
    PARAM_ERROR("10001","参数异常"),
    LOGIN_ERROR("10002","登录过期重新登录"),
    LOGIN_PASSWORD_ERROR("10003","账号密码错误"),
    NO_PERMISSION_ERROR("10004","没有权限配置"),

    ;


    /**
     * code
     */
    private String code;
    /**
     *
     * 描述
     */
    private String msg;
    ErrorCode(String code,String msg) {
        this.code = code;
        this.msg=msg;
    }


    @Override
    public String getCode() {
        return code;
    }
    @Override
    public String getMsg() {
        return msg;
    }

}

