//package com.live.server.controller;
//
//import com.live.common.domain.ResponseData;
//import com.live.common.domain.request.CommonPage;
//import com.live.common.domain.request.CommonStringId;
//import com.live.common.domain.request.TopLiveRequest;
//import com.live.common.domain.request.VideoRecommendRequest;
//import com.live.common.service.LeaguePointsRankService;
//import com.live.common.service.RoomService;
//import io.swagger.annotations.Api;
//import io.swagger.annotations.ApiOperation;
//import io.swagger.annotations.ApiResponse;
//import io.swagger.annotations.ApiResponses;
//import lombok.extern.slf4j.Slf4j;
//import org.springframework.web.bind.annotation.*;
//
//import javax.annotation.Resource;
//import javax.servlet.http.HttpServletRequest;
//
//@Slf4j
//@CrossOrigin
//@RestController
//@RequestMapping("/pcHome")
//@Api(tags = "PC版首页接口 API 文档")
//public class PcHomeController {
//
//    @Resource
//    private LeaguePointsRankService leaguePointsRankService;
//
//    @PostMapping(value = "/getLeagueType")
//    @ApiOperation(value = "获取联赛类型 欧冠 - 德甲 等")
//    @ApiResponses({
//            @ApiResponse(code = 200, message = "成功处理请求"),
//            @ApiResponse(code = 401, message = "没有权限访问该服务"),
//            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
//            @ApiResponse(code = 404, message = "未发现该服务"),
//            @ApiResponse(code = 500, message = "服务器内部错误")
//    })
//    public ResponseData<?> getLeagueType(HttpServletRequest request) {
//        return leaguePointsRankService.getLeagueType(request);
//    }
//
//    @PostMapping(value = "/getLeaguePointsRank")
//    @ApiOperation(value = "获取联赛积分榜 足球 sportsId = 0")
//    @ApiResponses({
//            @ApiResponse(code = 200, message = "成功处理请求"),
//            @ApiResponse(code = 401, message = "没有权限访问该服务"),
//            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
//            @ApiResponse(code = 404, message = "未发现该服务"),
//            @ApiResponse(code = 500, message = "服务器内部错误")
//    })
//    public ResponseData<?> getLeaguePointsRank(@RequestBody CommonStringId commonStringId, HttpServletRequest request) {
//        return leaguePointsRankService.getLeaguePointsRank(commonStringId, request);
//    }
//
//    @PostMapping(value = "/getLeaguePointsRankBasketball")
//    @ApiOperation(value = "获取联赛积分榜 篮球 sportsId = 1")
//    @ApiResponses({
//            @ApiResponse(code = 200, message = "成功处理请求"),
//            @ApiResponse(code = 401, message = "没有权限访问该服务"),
//            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
//            @ApiResponse(code = 404, message = "未发现该服务"),
//            @ApiResponse(code = 500, message = "服务器内部错误")
//    })
//    public ResponseData<?> getLeaguePointsRankBasketball(@RequestBody CommonStringId commonStringId, HttpServletRequest request) {
//        return leaguePointsRankService.getLeaguePointsRankBasketball(commonStringId, request);
//    }
//
//    @PostMapping(value = "/getHotExpert")
//    @ApiOperation(value = "热门专家")
//    @ApiResponses({
//            @ApiResponse(code = 200, message = "成功处理请求"),
//            @ApiResponse(code = 401, message = "没有权限访问该服务"),
//            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
//            @ApiResponse(code = 404, message = "未发现该服务"),
//            @ApiResponse(code = 500, message = "服务器内部错误")
//    })
//    public ResponseData<?> getHotExpert(HttpServletRequest request) {
//        return leaguePointsRankService.getHotExpert(request);
//    }
//
//    @PostMapping(value = "/getAnchorRecommend")
//    @ApiOperation(value = "主播推荐")
//    @ApiResponses({
//            @ApiResponse(code = 200, message = "成功处理请求"),
//            @ApiResponse(code = 401, message = "没有权限访问该服务"),
//            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
//            @ApiResponse(code = 404, message = "未发现该服务"),
//            @ApiResponse(code = 500, message = "服务器内部错误")
//    })
//    public ResponseData<?> getAnchorRecommend(@RequestBody CommonPage commonPage, HttpServletRequest request) {
//        return leaguePointsRankService.getAnchorRecommend(commonPage, request);
//    }
//
//}
