package com.live.common.domain.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

import java.util.Date;

@EqualsAndHashCode(callSuper = true)
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@TableName("t_match_odds")
public class MatchOdds extends BaseEntity {

    private Integer companyId;
    private String matchId;
    //类型（0: 初盘, 1: 即时盘）
    private Integer matchType;
    //0 主胜赔率 1让球  2 盘口
    private Double fieldOne;
    //0 平局赔率 1主队赔率 2 大球赔率
    private Double fieldTwo;
    //0 客胜赔率 1客兑赔率 2 小球赔率
    private Double fieldThree;
    //修改时间
    private Date changeTime;
    //指数类型 足球(0 欧赔 1 亚赔(让球) 2 大小球) 篮球(0 欧赔 1 让分指数 2 大小分指数)
    private Integer oddsType;
    //0足球 1篮球
    private Integer sportsType;

}
