package com.live.job.entity.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class AlStatSportsFootballDto {

    private String state;
    private List<AlStatCompetition> competitions;

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class AlStatCompetition {
        private Integer id;
        private String name;
        private String country;
        private String nameFull;
        private String nameEn;
        private String nameEnFull;
        private String competitionType;
        private String teamType;
        private String currSeason;
        private List<String> seasons;
        private String colour;
        private Integer hasDetail;

//        		  “id”: 1,						//赛事Id
//                “name”: “英超”,					//赛事名称（简称）
//                “nameFull”: “英格兰足球超级联赛”,	//赛事名称（全称）
//                “nameEn”: “Premier League”,		//赛事英文名称
//                “nameEnFull”: “Premier League”,		//赛事英文名称（全称）
//                “competitionType”: “league”,	//赛事类型（league: 联赛, cup: 杯赛）
//                “teamType”: “club”,				//参加球队的类型（club: 俱乐部, national: 国家队）
//                “country”: “England”,			//赛事举办国家
//                “currSeason”: “19/20”,			//当前赛季
//                “seasons”: [“18/19”, “19/20”],	//赛事对应的赛季索引
//                “colour”: “FF3333”,				//色号
//                “hasDetail”: 1					//是否有详细数据
    }

}
