package com.live.common.domain.dto.api;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ArticleSearchResponse {

    private List<TagInfoResponse> tags;

    private List<ArticleInfo> articleInfos;

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class ArticleInfo {
        private Integer id;
        private String title;
        private String dateTime;
    }

}
