package com.live.common.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.live.common.constant.ConstantValue;
import com.live.common.constant.RedisKeySplicing;
import com.live.common.domain.ResponseData;
import com.live.common.domain.dto.back.BackLoginResponse;
import com.live.common.domain.entity.SysUser;
import com.live.common.domain.request.back.LoginBackRequest;
import com.live.common.enums.StatusEnum;
import com.live.common.mapper.SysUserMapper;
import com.live.common.service.LoginService;
import com.live.common.service.RedisUtilsService;
import com.live.common.utils.JWTUtils;
import com.live.common.utils.MD5Util;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

@Slf4j
@Service
public class LoginServiceImpl implements LoginService {

    @Resource
    private RedisUtilsService redisUtilsService;
    @Resource
    private SysUserMapper sysUserMapper;

    @Override
    public ResponseData<?> login(LoginBackRequest loginBackRequest, HttpServletRequest request) {
        String password = MD5Util.string2MD5(loginBackRequest.getPassword());

        SysUser systemAccount = sysUserMapper.selectOne(Wrappers.<SysUser>lambdaQuery()
                .eq(SysUser::getUsername, loginBackRequest.getUserName())
                .eq(SysUser::getPassword, password)
        );

        if(systemAccount == null){
            return ResponseData.failResponse(404, "账户未找到");
        }

        if(systemAccount.getDeleted() == StatusEnum.DISABLE.getCode()){
            return ResponseData.failResponse(403, "账户被禁用");
        }

        String token = null;
        try {
            token = JWTUtils.generTokenByRS256(systemAccount);
            redisUtilsService.cacheStringInfoByDay(RedisKeySplicing.getUserToken(loginBackRequest.getUserName()), token, 1);
            return ResponseData.successResponse(BackLoginResponse.builder()
                    .token(token)
                    .roleId(systemAccount.getRoleId())
                    .userName(systemAccount.getUsername())
                    .imgPrefix(ConstantValue.AVATAR_URL)
                    .build());
        } catch (Exception e) {
            e.printStackTrace();
        }
        return ResponseData.failResponse();
    }

    @Override
    public ResponseData<?> logout(HttpServletRequest request) {
        String token = request.getHeader("token");
        SysUser sysUser = JWTUtils.getSysUser(token);
        redisUtilsService.removeByKey(RedisKeySplicing.getUserToken(sysUser.getUsername()));
        return ResponseData.successResponse();
    }
}
