package com.live.job.entity.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class AlStatFootballTeamPlayerDto {

    private String state;
    private List<FootballTeamPlayerDto> players;

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class FootballTeamPlayerDto {
        private Integer id;
        private String name;
        private String nameEn;
        private String country;
        private String birthday;
        private Integer marketValue;
        private String rnNumber;
        private String height;
        private String foot;
        private String position;
        private String mainPosition;
        private String sencondPosition1;
        private String sencondPosition2;
        private Integer nationalChosenTimes;
        private Integer nationalGoals;


//“id”: 25,						//球员Id
//                “name”: “萨拉赫”,				//球员名称
//                “nameEn”: “Mohamed Salah”,		//球员英文名
//                “country”: “Egypt”,				//国籍
//                “birthday”: “1992-06-15”,		//出生日期
//                “marketValue”: 150000000,		//球员当前身价（单位:欧元）
//                “rnNumber”: 11,					//球衣号码
//                “height”: “1.75m”,				//身高
//                “foot”: “left”,					//惯用脚（left左脚,right右脚,both左右脚）
//                “position”: “Striker”,			//位置（具体定义参考文件-个别名词解释）
//                “mainPosition”: “Right Winger”,	//主要位置（具体定义参考文件-个别名词解释）
//                “sencondPosition1”: “Centre-Forward”,	//次要位置1（具体定义参考文件-个别名词解释）
//                “sencondPosition2”: “Left Wing”,	//次要位置2（具体定义参考文件-个别名词解释）
//                “clubId”: 13,					//当前所属俱乐部id
//                “inTeamSince”: “2017-07-01”,	//入队日期
//                “contactEnd”: “2023-06-30”,		//当前合同截至
//                “loanFromClubId”: null,			//租借母队id
//                “loanFromClubName”: null,		//租借母队名称
//                “loanFromClubContractEnd”: “”,	//租借母队合同截至
//                “nationalChosenTimes”: 67,		//国家队入选次数
//                “nationalChosenTeam”: “”,		//为空表示成年国家队，U21、U18等表示各级青年队
//                “nationalGoals”: 41				//国家队进球数
    }

}
